/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.util.List;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentMatch;
import org.broadinstitute.sting.utils.Utils;

class UnmatchedArgumentException
extends ArgumentException {
    public UnmatchedArgumentException(ArgumentMatch invalidValues) {
        super(UnmatchedArgumentException.formatArguments(invalidValues));
    }

    private static String formatArguments(ArgumentMatch invalidValues) {
        StringBuilder sb = new StringBuilder();
        for (int index : invalidValues.indices.keySet()) {
            for (String value : (List)invalidValues.indices.get(index)) {
                sb.append(String.format("%nInvalid argument value '%s' at position %d.", value, index));
                if (value == null || !Utils.dupString(' ', value.length()).equals(value)) continue;
                sb.append("  Please make sure any line continuation backslashes on your command line are not followed by whitespace.");
            }
        }
        return sb.toString();
    }
}

