/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.walkers.Multiplexer;

public class ArgumentMatch
implements Iterable<ArgumentMatch> {
    public final ArgumentDefinition definition;
    public final String label;
    public final SortedMap<Integer, List<String>> indices = new TreeMap<Integer, List<String>>();
    public final Tags tags;

    public ArgumentMatch() {
        this(null, null);
    }

    private ArgumentMatch(String label, ArgumentDefinition definition) {
        this.label = label;
        this.definition = definition;
        this.tags = new Tags();
    }

    public ArgumentMatch(String label, ArgumentDefinition definition, int index, Tags tags) {
        this(label, definition, index, null, tags);
    }

    private ArgumentMatch(String label, ArgumentDefinition definition, int index, String value, Tags tags) {
        this.label = label;
        this.definition = definition;
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            values.add(value);
        }
        this.indices.put(index, values);
        this.tags = tags;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArgumentMatch)) {
            return false;
        }
        ArgumentMatch otherArgumentMatch = (ArgumentMatch)other;
        return this.definition.equals(otherArgumentMatch.definition) && this.label.equals(otherArgumentMatch.label) && this.indices.equals(otherArgumentMatch.indices) && this.tags.equals(otherArgumentMatch.tags);
    }

    ArgumentMatch transform(Multiplexer multiplexer, Object key) {
        TreeMap newIndices = new TreeMap();
        for (Map.Entry<Integer, List<String>> index : this.indices.entrySet()) {
            ArrayList<String> newEntries = new ArrayList<String>();
            for (String entry : index.getValue()) {
                newEntries.add(multiplexer.transformArgument(key, entry));
            }
            newIndices.put(index.getKey(), newEntries);
        }
        ArgumentMatch newArgumentMatch = new ArgumentMatch(this.label, this.definition);
        newArgumentMatch.indices.putAll(newIndices);
        return newArgumentMatch;
    }

    public String toString() {
        return this.label;
    }

    @Override
    public Iterator<ArgumentMatch> iterator() {
        return new Iterator<ArgumentMatch>(){
            private Iterator<Integer> indexIterator = null;
            private Iterator<String> tokenIterator = null;
            Integer nextIndex = null;
            String nextToken = null;
            {
                this.indexIterator = ArgumentMatch.this.indices.keySet().iterator();
                this.prepareNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextToken != null;
            }

            @Override
            public ArgumentMatch next() {
                if (this.nextIndex == null || this.nextToken == null) {
                    throw new IllegalStateException("No more ArgumentMatches are available");
                }
                ArgumentMatch match = new ArgumentMatch(ArgumentMatch.this.label, ArgumentMatch.this.definition, this.nextIndex, this.nextToken, ArgumentMatch.this.tags);
                this.prepareNext();
                return match;
            }

            private void prepareNext() {
                if (this.tokenIterator != null && this.tokenIterator.hasNext()) {
                    this.nextToken = this.tokenIterator.next();
                } else {
                    this.nextIndex = null;
                    this.nextToken = null;
                    while (this.indexIterator.hasNext()) {
                        this.nextIndex = this.indexIterator.next();
                        if (ArgumentMatch.this.indices.get(this.nextIndex) == null) continue;
                        this.tokenIterator = ((List)ArgumentMatch.this.indices.get(this.nextIndex)).iterator();
                        if (!this.tokenIterator.hasNext()) continue;
                        this.nextToken = this.tokenIterator.next();
                        break;
                    }
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an argument match from the collection while iterating.");
            }
        };
    }

    public void mergeInto(ArgumentMatch other) {
        this.indices.putAll(other.indices);
    }

    public void addValue(int index, String value) {
        if (!this.indices.containsKey(index) || this.indices.get(index) == null) {
            this.indices.put(index, new ArrayList());
        }
        ((List)this.indices.get(index)).add(value);
    }

    public boolean hasValueAtSite(int index) {
        return this.indices.get(index) != null && ((List)this.indices.get(index)).size() >= 1 || this.isArgumentFlag();
    }

    public List<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (int index : this.indices.keySet()) {
            if (this.indices.get(index) == null) continue;
            values.addAll((Collection)this.indices.get(index));
        }
        return values;
    }

    private boolean isArgumentFlag() {
        return this.definition != null && this.definition.isFlag;
    }
}

