/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.util.Comparator;
import java.util.TreeSet;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.Counts;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class SuffixArray {
    public final long inverseSA0;
    public final Counts occurrences;
    protected final long[] sequence;
    protected final int sequenceInterval;
    protected final BWT bwt;

    public SuffixArray(long inverseSA0, Counts occurrences, long[] sequence) {
        this(inverseSA0, occurrences, sequence, 1, null);
    }

    public SuffixArray(long inverseSA0, Counts occurrences, long[] sequence, int sequenceInterval, BWT bwt) {
        this.inverseSA0 = inverseSA0;
        this.occurrences = occurrences;
        this.sequence = sequence;
        this.sequenceInterval = sequenceInterval;
        this.bwt = bwt;
        if (sequenceInterval != 1 && bwt == null) {
            throw new ReviewedStingException("A BWT must be provided if the sequence interval is not 1");
        }
    }

    public long length() {
        if (this.bwt != null) {
            return this.bwt.length() + 1L;
        }
        return this.sequence.length;
    }

    public long get(long index) {
        int iterations = 0;
        while (index % (long)this.sequenceInterval != 0L) {
            if (index == this.inverseSA0) {
                index = 0L;
            } else {
                byte base = this.bwt.getBase(index);
                index = this.bwt.counts(base) + this.bwt.occurrences(base, index);
            }
            ++iterations;
        }
        return (this.sequence[(int)(index / (long)this.sequenceInterval)] + (long)iterations) % this.length();
    }

    public static SuffixArray createFromReferenceSequence(byte[] sequence) {
        TreeSet<Integer> suffixArrayBuilder = new TreeSet<Integer>(new SuffixArrayComparator(sequence));
        Counts occurrences = new Counts();
        for (byte base : sequence) {
            occurrences.increment(base);
        }
        for (int i = 0; i <= sequence.length; ++i) {
            suffixArrayBuilder.add(i);
        }
        long[] suffixArray = new long[suffixArrayBuilder.size()];
        int i = 0;
        for (Integer element : suffixArrayBuilder) {
            suffixArray[i++] = element.intValue();
        }
        long inverseSA0 = -1L;
        for (i = 0; i < suffixArray.length; ++i) {
            if (suffixArray[i] != 0L) continue;
            inverseSA0 = i;
        }
        if (inverseSA0 < 0L) {
            throw new ReviewedStingException("Unable to find first inverse SA entry in generated suffix array.");
        }
        return new SuffixArray(inverseSA0, occurrences, suffixArray);
    }

    private static class SuffixArrayComparator
    implements Comparator<Integer> {
        private final String sequence;

        public SuffixArrayComparator(byte[] sequence) {
            this.sequence = StringUtil.bytesToString(sequence);
        }

        @Override
        public int compare(Integer lhs, Integer rhs) {
            String lhsSuffixArray = this.sequence.substring(lhs);
            String rhsSuffixArray = this.sequence.substring(rhs);
            return lhsSuffixArray.compareTo(rhsSuffixArray);
        }
    }
}

