/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;
import org.broad.tribble.util.URLHelper;

public class SeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableHTTPStream.class);
    private long position = 0L;
    private long contentLength = -1L;
    URLHelper helper;

    public SeekableHTTPStream(URL url) {
        this(SeekableStreamFactory.getURLHelper(url));
    }

    public SeekableHTTPStream(URLHelper helper) {
        this.helper = helper;
        try {
            this.contentLength = helper.getContentLength();
        }
        catch (IOException e) {
            log.error("Error fetching content length for URL: " + helper.getUrl(), e);
        }
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesToSkip = Math.min(n, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("read: " + offset + " " + len);
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        InputStream is = null;
        String byteRange = "";
        int n = 0;
        try {
            long end = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                if (this.position > this.contentLength) {
                    log.info("Warning: Unexpected postion value.  position=" + this.position + " contentLength=" + this.contentLength);
                    int n2 = -1;
                    return n2;
                }
                if (end > this.contentLength) {
                    end = this.contentLength;
                    len = (int)(end - this.position + 1L);
                }
            }
            byteRange = "bytes=" + this.position + "-" + end;
            is = this.helper.openInputStreamForRange(this.position, end);
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n += count;
            }
            this.position += (long)n;
            int n4 = n;
            return n4;
        }
        catch (IOException e) {
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                log.error("Error: " + e.getMessage() + " encountered reading " + this.helper.getUrl() + ".  " + byteRange + "  " + "content-length=" + this.contentLength);
                if (n < 0) {
                    int n5 = -1;
                    return n5;
                }
                this.position += (long)n;
                int n6 = n;
                return n6;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }

    @Override
    public boolean eof() throws IOException {
        return this.contentLength > 0L && this.position >= this.contentLength;
    }
}

