#!/usr/bin/perl
use strict;
use warnings;

# read in the two vcf files, first read in the preferred aligner ones

# #CHROM  POS     ID      REF     ALT     QUAL    FILTER  INFO	FORMAT	BCT14
# chrY    21153846        rs4030414       A       T       0       .       DB;HaplotypeScore=17.0525;MQRankSum=-1.543;ReadPosRankSum=0.785 AD:DP:MA:RD:RO  .:DP=315;RD=1;AD=312;RO=0.997;MA=1

if(@ARGV!=7){
	die "Usage: perl merge_vcf.pl <sample name> <vcf from preferred aligner> <vcf from less preferred confident aligner> <FLAG of if low confident SNVs needed: T-need; F-not need > <outpu folder> <RRPS high> <RRPS low>\n";
}

open(FO,">$ARGV[4]/$ARGV[0].ANNOVAR.txt") || die "cannot open $ARGV[4]/$ARGV[0].ANNOVAR.txt\n";
if ($ARGV[3] eq "T" ){
	open(FO2,">$ARGV[4]/$ARGV[0].Low_SNVs.txt") || die "cannot open $ARGV[4]/$ARGV[0].Low_SNVs.txt\n";
}
my ($ls,$loci);
my $RPRS_high=$ARGV[5];
my $RPRS_low=$ARGV[6];
my @line;
my %hash;
my $rprs;
open(FP1,"<$ARGV[1]") || die "cannot open $ARGV[1]\n";
while($ls=<FP1>){
	if($ls=~/^#/){next;}
	if($ls=~/ReadPosRankSum=/) {
		($rprs)=($ls=~/^.*?ReadPosRankSum=([+-]?\d+\.\d+)\t*/);
		# test
		#print $rprs,",";
		# end test
		if( $rprs< $RPRS_low || $rprs > $RPRS_high ) {next;}
	}
	chomp($ls);
	@line=split(/\t/,$ls);
	$loci=join("_",@line[0,1,3,4]);
	#print "$line[7]\n";
	$hash{$loci}=$line[7].":".$line[9].";CONF=1";
} 
close(FP1);

open(FP2,"<$ARGV[2]") || die "cannot open $ARGV[2]\n";
while($ls=<FP2>){
	if($ls=~/^#/){next;}
	if($ls=~/ReadPosRankSum=/) {
		($rprs)=($ls=~/^.*?ReadPosRankSum=([-+]?\d+\.\d+)\t*/);
		if( $rprs< $RPRS_low || $rprs > $RPRS_high ) {next;}
	}
	chomp($ls);
	@line=split(/\t/,$ls);
	$loci=join("_",@line[0,1,3,4]);
	if($hash{$loci}){
		$hash{$loci}=~s/=1$/=2/;
	}else{
		if($ARGV[3] eq "T" ){
		 	$hash{$loci}=$line[7].":".$line[9].";CONF=0";
		}
	}
}

my ($k,$conf);



foreach $k (keys %hash){
	if( $hash{$k}=~/=[1,2]$/) { 
		my @l=split(/_/,$k);
		print FO join("\t",@l[0,1,1,2,3]),"\t","$hash{$k}","\n";  
	}
	else { 
		if($ARGV[3] eq "T" ){
			my @l=split(/_/,$k);
	                print FO2 join("\t",@l[0,1,1,2,3]),"\t","$hash{$k}","\n";

		}
	} 

}
