#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### tang.xiaojia@mayo.edu
### Xiaojia Tang
### last updated: May 07 2013


############################################################
#		$1		=	/path/to/input directory
#		$2		=	name of the samples
#		$3		=	bamfiles from same aligner are "," seperated and ":" for different aligners
#		$4		=	/path/to/outputfolder
#		$5		=	/path/to/configuration file
#############################################################


if [ $# != 5 ]
then
	echo -e "Main script to run the whole tool\nUsage: ./main.sh </path/to/input directory><sample name><bamfiles from same aligner are "," seperated and ":" for different aligners></path/to/outputfolder></path/to/configuration file>"
	exit 1;
else
	echo -e "\n******* Started Running the Analysis *******\n"
	#set -x
	START=$(date +%s)
	input=$1
	sample=$2
	bam=$3
	output=$4
	config=$5

	#checkParams.sh $1 $3 $5

	if [ -d $output ]
	then
		echo "Ouput folder already exist, user needs to delete the previous folder or give a different folder name"
		exit 1;
	else
		mkdir -p $output/logs
	fi
	
	cp $config $output/config.txt
	config=$output/config.txt
	du=`dos2unix $config 2>&1`
	cat $config | sed 's/^[ \t]*//;s/[ \t]*$//' > $config.tmp
	mv $config.tmp $config
	samtools=$( cat $config | grep '^SAMTOOLS=' | sed -e '/SAMTOOLS=/s///g')
	script_path=$( cat $config | grep '^SCRIPT_PATH=' | sed -e '/SCRIPT_PATH=/s///g')
	if [ ! $script_path ]
	then
		echo "configuration file is not set right"
		exit 1;
	fi
	aligner=$( cat $config | grep '^ALIGNER=' | sed -e '/ALIGNER=/s///g')
	
	if [[ `echo $aligner | tr ":" "\n" | wc -l` -le 1  || `echo $aligner | tr ":" "\n" | wc -l` -gt 2 ]]
	then
		echo " ALIGNER: $aligner paramter is not set right, please go to the manual"
		exit 1;
	fi	
		
	if [[ `echo $bam | tr ":" "\n" | wc -l` -le 1  || `echo $bam | tr ":" "\n" | wc -l` -gt 2 ]]
	then
		echo " BAMs: $bam paramter is not set right, please go to the manual"
		exit 1;
	fi
	let j=1
	for bb in `echo $bam | tr ":" " "`
	do
		for bamfile in `echo $bb | tr "," " "`
		do
			if [ ! -s  $input/$bamfile  ]
			then 
				echo "cannot find the bam files: $input/$bamfile"
				exit 1;
			fi 
			#### validate the bam files
			$samtools/samtools view -H $input/$bamfile 1>$input/$bamfile.header 2> $input/$bamfile.log
			if [[ `cat $input/$bamfile.log | wc -l` -gt 0 || `cat $input/$bamfile.header | wc -l` -le 0 ]]
			then
				echo "$input/$bamfile bam is truncated or corrupted"
				rm $input/$bamfile.header $input/$bamfile.log
				exit 1;
			else
				rm $input/$bamfile.header $input/$bamfile.log
			fi	
		done
		aligner=$( cat $config | grep '^ALIGNER=' | sed -e '/ALIGNER=/s///g'| tr "[A-Z]" "[a-z]" | tr ":" "\n" | head -n $j | tail -n 1)
		mkdir -p $output/$aligner
		$script_path/eSNV.sh $input $sample $bb $output/$aligner $config $j  > $output/logs/$aligner.log 2>&1 &
		echo " submitted the $aligner BAM file for preprocessing"
		eval pid${j}=$!
		let j=j+1
	done	
	wait $pid1 $pid2
	
	$script_path/eSNV_Merge.sh $sample $output $config > $output/logs/eSNV_Merge.log 2>&1 
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Main script for $sample took $DIFF seconds"
	echo -e "\n******* Completed Running the Analysis *******\n"
	cd $output
fi	
