#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### last updated: NOV 07 2012

if [ $# != 5 ]
then
	echo -e "script to read group and platform information to a BAM file\nUsage: ./ReorderBAM.sh <path/to/input BAM file> <sample name> </path/to/temp directory> <configuraion file></path/to/log directory>"
	exit 1;
else
	set -x
	START=$(date +%s)
	input_bam=$1 
	sample=$2
	tmp_dir=$3 
	config=$4
	log_dir=$5
	
	picard=$( cat $config | grep '^PICARD=' | sed -e '/PICARD=/s///g')
	samtools=$( cat $config | grep '^SAMTOOLS=' | sed -e '/SAMTOOLS=/s///g')
	java=$( cat $config | grep '^JAVA=' | sed -e '/JAVA=/s///g')
	ref=$( cat $config | grep '^REF_GENOME=' | sed -e '/REF_GENOME=/s///g')
	mem=$( cat $config | grep '^JVM_MEM=' |sed -e '/JVM_MEM=/s///g')
	
	$java/java $mem -jar $picard/AddOrReplaceReadGroups.jar \
	INPUT=$input_bam \
	OUTPUT=$input_bam.rg.bam \
	SM=$sample ID=$sample PU=$sample LB=$ref PL=illumina CREATE_INDEX=true \
	TMP_DIR=$tmp_dir \
	VALIDATION_STRINGENCY=SILENT  > $log_dir/$sample.readgroup.log 2>&1
	file=`echo $input_bam.rg.bam | sed -e 's/\(.*\)..../\1/'`
	mv $file.bai $input_bam.bai
	mv $input_bam.rg.bam $input_bam
	
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Adding RG and PL tag to the BAM : $input_bam took $DIFF seconds"  
fi
	
