#!/bin/bash

####

usage()
{
cat << EOF
######
##      eSNV-Detect v1.0 Annovar installation script
##      Script Options:
##	-p	<pacakage>	-	(REQUIRED)	full path to downloaded annovar package
##      -d      <directory>      -       (REQUIRED) full/path/to/annovar directory user needs to install at
##      -h              -   Display this usage/help text (No arg)
##
#################################################################################################################
##
## Authors:             Saurabh Baheti
## Creation Date:       January 19 2014
## Last Modified:       January 19 2014
##
## For questions, comments, or concerns, contact Saurabh (baheti.saurabh@mayo.edu)
##
#################################################################################################################
EOF
}

while getopts "p:d:h" OPTION; do
  case $OPTION in
        h) usage
        exit ;;
	p) package=$OPTARG ;;
        d) directory=$OPTARG ;;
   \?) echo "Invalid option: -$OPTARG. See output file for usage." >&2
       usage
       exit ;;
    :) echo "Option -$OPTARG requires an argument. See output file for usage." >&2
       usage
       exit ;;
  esac
done

if [[ -z "$directory"  || ! -s "$package" || -z "$package" ]]
then
        echo "Must provide at least required options. See output file for usage." >&2
        usage
        exit 1;
fi
START=$(date +%s)

echo -e "\n###############################################################################################"
echo -e "#"
echo -e "# This is the eSNV-Detect v1.0 Annovar installer. "
echo -e "# It will work under a bash shell"
echo -e "# It will download all necessary files and install them. "
echo -e "# Please restart your shell to make changes take effect"
echo -e "#"
echo -e "###############################################################################################"




####change this if user wants to run some other species or build on genome
genome="hg19"

### check for tar ball
tar=`which tar`
#### check and add Perl to env variable
perl=`which perl`


$tar -C $directory -xzf $package

for database in 1000g2012apr genomicSuperDups phastConsElements46way 
do
	$perl $directory/annovar/annotate_variation.pl -buildver $genome -downdb $database $directory/annovar/humandb/
done

for database in snp135 esp6500si_all refGene ljb_all avsift
do
	$perl $directory/annovar/annotate_variation.pl -buildver $genome -downdb -webfrom annovar $database $directory/annovar/humandb/
done


echo -e "\n ************************\n"
echo -e "annovar is installed at $directory/annovar/"
echo -e "User needs to replace these two lines in the configuration file to run the workflow"
echo -e "ANNOVAR=$directory/annovar"
echo -e "ANNOVARDB=$directory/annovar/humandb"
echo -e "\n ************************\n"


 






