#!/bin/bash
### tang.xiaojia@mayo.edu
### Xiaojia Tang
### last updated: NOV 27 2012

if [ $# != 4 ]
then 
	echo "Usage: ./raw_vcf.sh <bam file> <sample name> <config.txt> <output dir>\n"
	exit 1
else
	#set -x 
	START=$(date +%s)
	bam=$1
	sample=$2
	config=$3
	out_dir=$4
	
	samtools=$( cat $config | grep '^SAMTOOLS=' | sed -e '/SAMTOOLS=/s///g')
	bcftools=$( cat $config | grep '^BCFTOOLS=' | sed -e '/BCFTOOLS=/s///g')
	script_path=$( cat $config | grep '^SCRIPT_PATH=' | sed -e '/SCRIPT_PATH=/s///g')
	perl=$( cat $config | grep '^PERL=' | sed -e '/PERL=/s///g')
	ref=$(cat $config | grep '^REF_GENOME=' |  sed -e '/REF_GENOME=/s///g')
	min_alt_reads=$(cat $config | grep '^MIN_ALT_READS=' |  sed -e '/MIN_ALT_READS=/s///g')
	min_depth=$(cat $config | grep '^MIN_READ_DEPTH=' |  sed -e '/MIN_READ_DEPTH=/s///g')
	r_cutoff=$(cat $config | grep '^R_CUTOFF=' |  sed -e '/R_CUTOFF=/s///g')
	r_cutoff2=$(cat $config | grep '^R_CUTOFF2=' |  sed -e '/R_CUTOFF2=/s///g')
	
	if [ `echo $bam | tr " " "\n" | wc -l` -gt 1 ]
	then
		input=""
		for i in `echo $bam`
		do
			input=$input"INPUT=$i "
		done
		$script_path/MergeBAMs.sh "$input" $out_dir/$sample.bam $sample $out_dir $config $out_dir/logs no
	else
		cp $bam $out_dir/$sample.bam
		cp $bam.bai $out_dir/$sample.bam.bai
	fi	
	bam=$out_dir/$sample.bam
	#$samtools/samtools mpileup -AB -f $ref $bam | gzip > $out_dir/$sample.pileup.gz 	
	$samtools/samtools mpileup -ABu -f $ref $bam | $bcftools/bcftools view -N - | $perl/perl $script_path/parse_samtools_vcf.pl $sample $min_depth $min_alt_reads $r_cutoff $r_cutoff2 > $out_dir/$sample.vcf
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo " Annotation of VCF file for $sample took $DIFF seconds"
fi

