#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### last updated: NOV 07 2012

if [ $# != 6 ]
then
	echo -e "preprocessing script for each type of BAM\nUsage: ./eSNV.sh </path/to/input directory><sample name><bamfiles "," seperated></path/to/outputfolder></path/to/configuration file><flag for aligner>"
	exit 1;
else
	set -x
	START=$(date +%s)
	input=$1
	sample=$2
	bam=$3
	output=$4
	config=$5
	flag=$6
	
	## create the directories
	mkdir -p $output
	script_path=$( cat $config | grep '^SCRIPT_PATH=' | sed -e '/SCRIPT_PATH=/s///g')
	samtools=$( cat $config | grep '^SAMTOOLS=' |sed -e '/SAMTOOLS=/s///g')
	aligner=$( cat $config | grep '^ALIGNER=' | sed -e '/ALIGNER=/s///g'| tr "[A-Z]" "[a-z]" | tr ":" "\n" | head -n $flag | tail -n 1)
	recal_flag=$( cat $config | grep '^RECALIBRATION=' |  sed -e '/RECALIBRATION=/s///g' | tr "[A-Z]" "[a-z]")
	realign_flag=$( cat $config | grep '^REALIGNEMNT=' |  sed -e '/REALIGNEMNT=/s///g' |tr "[A-Z]" "[a-z]")
	echo -e "\n******* BAM for $aligner processing script started *******\n"
	
	### prepocess the BAM file
	mkdir -p $output/alignment
	align=$output/alignment
	$script_path/ProcessBAM.sh $input $bam $sample $align $config $flag
	#read -p "press enter"
	### realign the BAM file
	if [[ $realign_flag == "yes" ]]
	then
		mkdir -p $output/realignment
		realign=$output/realignment
		bam=$align/$sample.bam
		$samtools/samtools view -H $bam 1>$bam.header 2>$bam.fix.log
		if [[ `cat $bam.fix.log | wc -l` -gt 0 || `cat $bam.header | wc -l` -le 0  ]]
		then
			echo "Preprocessing of the bam files for $sample failed to run"
			exit 1;
		else
			rm $bam.header $bam.fix.log
		fi	
		$script_path/realign.sh $bam $sample $realign $config $flag
	fi
	
	### recalibration the BAM file
	if [[ $recal_flag == "yes" ]]
	then
		mkdir -p $output/recalibration
		recal=$output/recalibration
		if [[ $realign_flag == "yes" ]]
		then
			bam=$realign/$sample.bam
		else
			bam=$align/$sample.bam
		fi	
		$samtools/samtools view -H $bam 1>$bam.header 2>$bam.fix.log
		if [[ `cat $bam.fix.log | wc -l` -gt 0 || `cat $bam.header | wc -l` -le 0  ]]
		then
			echo "realignment of the bam file for $sample failed to run"
			exit 1;
		else
			rm $bam.header $bam.fix.log
		fi
		$script_path/recal.sh $bam $sample $recal $config $flag	
	fi
	
	### variant calling of the BAM file
	mkdir -p $output/variant
	variant=$output/variant
	if [[ $recal_flag == "yes" ]]
	then	
		bam=$recal/$sample.bam
	elif [[ $realign_flag == "yes" ]]
	then
		bam=$realign/$sample.bam
	else
		bam=$align/$sample.bam
	fi
	$samtools/samtools view -H $bam 1>$bam.header 2>$bam.fix.log
	if [[ `cat $bam.fix.log | wc -l` -gt 0 || `cat $bam.header | wc -l` -le 0  ]]
	then
		echo "recalibration of the bam file for $sample failed to run"
		exit 1;
	else
		rm $bam.header $bam.fix.log
	fi
	$script_path/variants.sh $bam $sample $variant $align $aligner $config
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo -e "\n******* BAM from $aligner processing took $DIFF seconds and completed *******\n"
fi
