#!/bin/bash
### tang.xiaojia@mayo.edu
### Xiaojia Tang
### last updated: NOV 27 2012

if [ $# -ne 4 ]
then
	echo -e "script to annotate variants using annovar\nUsage ./annovar.sh <sample> </path/to/Annovar input> <config file> </path/to/output>" 
	exit 1
else
	set -x
	START=$(date +%s)
	sample=$1
	input=$2
	config=$3
	output=$4
	perl=$( cat $config | grep '^PERL=' | sed -e '/PERL=/s///g')
	annovar=$( cat $config | grep '^ANNOVAR=' | sed -e '/ANNOVAR=/s///g')
	annovardb=$( cat $config | grep '^ANNOVARDB=' | sed -e '/ANNOVARDB=/s///g')

	# annotate the genelist 
	$perl/perl $annovar/summarize_annovar.pl -out $output/$sample.anno -buildver hg19 -ver1000g 1000g2012apr -verdbsnp 135 -veresp 6500si -remove $input $annovardb >$output/logs/$sample.anno.log 2>&1
	
	if [[ `grep "Error" $output/logs/$sample.anno.log | wc -l` -gt "1"  ]]  
	then
		echo " annova failed!!"
		cat $output/logs/$sample.anno.log
		exit 1
	fi

	$perl/perl -pe 'while (s/(,"[^"]+),/\1<COMMA>/g) {1}; s/"//g; s/,/\t/g; s/<COMMA>/,/g' < $output/$sample.anno.genome_summary.csv > $output/$sample.anno.genome_summary.txt 

	mkdir $output/annovar_results
	mv $output/*_filtered $output/annovar_results
	mv $output/*.csv $output/annovar_results
	mv $output/$sample.anno.log $output/annovar_results
	mv $input $output/annovar_results 
	#rm $input
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo " Annotation of variants for $sample took $DIFF seconds"
fi
