#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### last updated: NOV 07 2012

if [ $# != 7 ]
then
	echo -e "script to sort a  BAM file\nUsage: ./SortBAM.sh <path/to/input BAM file> </path/to/output BAM file> <sample name> </path/to/temp directory> <configuraion file></path/to/log directory><flag for sorting order>"
	exit 1;
else
	set -x
	START=$(date +%s)
	input_bam=$1 
	output_bam=$2
	sample=$3
	tmp_dir=$4 
	config=$5
	log_dir=$6
	order=$7
	
	picard=$( cat $config | grep '^PICARD=' | sed -e '/PICARD=/s///g')
	samtools=$( cat $config | grep '^SAMTOOLS=' | sed -e '/SAMTOOLS=/s///g')
	java=$( cat $config | grep '^JAVA=' | sed -e '/JAVA=/s///g')
	mem=$( cat $config | grep '^JVM_MEM=' |sed -e '/JVM_MEM=/s///g')
		
	$java/java $mem -jar $picard/SortSam.jar \
	INPUT=$input_bam \
	OUTPUT=$output_bam \
	SO=$order \
	TMP_DIR=$tmp_dir \
	CREATE_INDEX=true \
	VALIDATION_STRINGENCY=SILENT > $log_dir/$sample.sort.log 2>&1	
	file=`echo $output_bam | sed -e 's/\(.*\)..../\1/'`
	mv $file.bai $output_bam.bai
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Sorting the BAM : $input_bam took $DIFF seconds"  


fi
	
