#!/bin/bash
### tang.xiaojia@mayo.edu
### Xiaojia Tang
### last updated: NOV 27 2012

if [ $# != 4 ]
then 
	echo "Usage: sh **.sh <full path to vcf file> <bam file> <config file> <output folder>  Notice that vcf and bam should be in the same sorting"
	exit
else
	set -x
	START=$(date +%s)
	vcf=$1
	bam=$2
	config=$3
	variant=$4
	mem=$( cat $config | grep '^JVM_MEM=' |sed -e '/JVM_MEM=/s///g')
	java=$(cat $config | grep -w '^JAVA=' | sed -e '/JAVA=/s///g')
	gatk=$(cat $config | grep -w '^GATK=' | sed -e '/GATK=/s///g')
	ref=$(cat $config | grep -w '^REF_GENOME=' | sed -e '/REF_GENOME=/s///g' )
	dbSNP=$(cat $config | grep -w '^dbSNP_REF=' | sed -e '/dbSNP_REF=/s///g' )
	mkdir -p $variant/temp
	$java/java $mem -Djava.io.tmpdir=$variant/temp -jar $gatk/GenomeAnalysisTK.jar \
	-R $ref \
	-T VariantAnnotator \
	-I $bam \
	-V $vcf \
	--dbsnp $dbSNP \
	-L $vcf --out $vcf.temp -A QualByDepth -A ReadPosRankSumTest 
	mv $vcf.temp $vcf
	rm -Rf $vcf.temp.idx $variant/temp
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo " Annotation of VCF file for $sample took $DIFF seconds"
fi
