#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### last updated: NOV 07 2012

if [ $# != 5 ]
then
	echo -e "script to realign BAM file\nUsage: ./ProcessBAM.sh <input BAM file> <sample name> <input directory> <configuraion file>"
	exit 1;
else
	set -x
	START=$(date +%s)
	bam=$1 
	sample=$2 
	realign=$3 
	config=$4
	flag=$5
	mkdir -p $realign/temp
	temp=$realign/temp
	mkdir -p $realign/logs
	logs=$realign/logs
	
	java=$( cat $config | grep '^JAVA=' | sed -e '/JAVA=/s///g')
	gatk=$( cat $config | grep '^GATK=' | sed -e '/GATK=/s///g')
	ref=$( cat $config | grep '^REF_GENOME=' |sed -e '/REF_GENOME=/s///g')
	mem=$( cat $config | grep '^JVM_MEM=' |sed -e '/JVM_MEM=/s///g')
	dbSNP=$( cat $config | grep '^dbSNP_REF=' | sed -e '/dbSNP_REF=/s///g')
	script_path=$( cat $config | grep '^SCRIPT_PATH=' | sed -e '/SCRIPT_PATH=/s///g')
    aligner=$( cat $config | grep '^ALIGNER=' |sed -e '/ALIGNER=/s///g'| tr "[A-Z]" "[a-z]" | tr ":" "\n" | head -n $flag | tail -n 1)
    Realign_params=$( cat $config | grep '^Realign_params=' | sed -e '/Realign_params=/s///g')
	echo -e "\n******* Realignment $aligner BAM script started *******\n"
	## GATK Target Creator
	$java/java $mem -Djava.io.tmpdir=$temp \
	-jar $gatk/GenomeAnalysisTK.jar \
    -R $ref \
    -T RealignerTargetCreator \
	-known $dbSNP \
    -I $bam \
    -o $realign/$sample.forRealigner.intervals > $logs/$sample.RealignerTargetCreator.log 2>&1
	
	### realignment
	$java/java $mem -Djava.io.tmpdir=$temp \
	-jar $gatk/GenomeAnalysisTK.jar \
	-R $ref \
	-T IndelRealigner \
	-I $bam \
	-known $dbSNP \
	--out $realign/$sample.bam  \
	-targetIntervals $realign/$sample.forRealigner.intervals $Realign_params > $logs/$sample.IndelRealigner.log 2>&1	
        
	mv $realign/$sample.bai $realign/$sample.bam.bai
	#rm $realign/$sample.forRealigner.intervals
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Realignment of $sample took $DIFF seconds"
	echo -e "\n******* Realignment $aligner BAM script completed *******\n"
fi	
