#!/bin/bash

if [ $# != 6 ]
then	
	echo -e "script to run variant calling and annotate vcf files\nUsage: ./variants.sh </path/to/bam file (full path)> <sample name>  </path/to/variant folder (full path)></path/to/alignment folder/><aligner inforamtion></path/to/config file (full path)>"
	exit 1;	
else
	set -x
	START=$(date +%s)
	bam=$1
	sample=$2
	variant=$3
	align=$4
	aligner=$5
	config=$6

    script_path=$( cat $config | grep '^SCRIPT_PATH=' | sed -e '/SCRIPT_PATH=/s///g')
	recal_flag=$( cat $config | grep '^RECALIBRATION=' |  sed -e '/RECALIBRATION=/s///g' | tr "[A-Z]" "[a-z]")
	realign_flag=$( cat $config | grep '^REALIGNEMNT=' |  sed -e '/REALIGNEMNT=/s///g' |tr "[A-Z]" "[a-z]")
	
	mkdir -p $variant/logs
	logs=$variant/logs
	
	echo -e "\n******* Variant Calling for $aligner BAM script started *******\n"
	### generate 1. pileup.gz   2. filtered vcf
	if [ $aligner == "tophat" ]
	then
		if [[ $recal_flag == "yes" || $realign_flag == "yes" ]]
		then
			input_bam="$align/$sample.junction.bam $bam"
		else
			input_bam=$bam
		fi	
	else
		input_bam=$bam
	fi
	
	$script_path/raw_vcf.sh "$input_bam" $sample $config $variant > $logs/$sample.vcall.log 2>&1

	### GATK ReadPosRankSum test
	bam=$variant/$sample.bam

	$script_path/GATK_RPRS.sh $variant/$sample.vcf $bam $config $variant > $logs/$sample.RPRS.log 2>&1 
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Variant Calling of $sample took $DIFF seconds"
	echo -e "\n******* Variant Calling $aligner BAM script completed *******\n"
fi
