#!/usr/bin/perl
use strict;
use warnings;

# to be used in pipeline. input from standart input.
# to be done: get input params to be used as the cutoffs below.

# The cutoffs:
#my $dp_cutoff=3;
#my $alt_cutoff=3;
#my $r_cutoff=0.1;
#my $r_cutoff2=0.05;
# samtools mpileup raw vcf format: 
# ##fileformat=VCFv4.1
# ##samtoolsVersion=0.1.14 (r933:170)
# #CHROM  POS     ID      REF     ALT     QUAL    FILTER  INFO    FORMAT  BCT40
# chr1    10089   .       C       X       0       .       DP=1;I16=1,0,0,0,39,1521,0,0,50,2500,0,0,0,0,0,0        PL      0,3,39

if(@ARGV !=5) {
	die "<sample name><min read depth><min# of alternate reads><r_cutoff><r_cutoof2> \n";
}
my $sample=shift @ARGV;
my $dp_cutoff=shift @ARGV;
my $alt_cutoff=shift @ARGV;
my $r_cutoff=shift @ARGV;
my $r_cutoff2=shift @ARGV;

#my (@line,@alt,@info,@I16);
my (@infos,@line);
my ($ref,$alt,$ratio,$new_info,$rcf);
while(<STDIN>){
	if($_=~/^##/){
		print $_;
		next;
	}
	if($_=~/^#CHROM/){
		print "##FORMAT=<ID=DP,Number=1,Type=Integer,Description=\"Total Depth\">\n";
		print "##FORMAT=<ID=RD,Number=1,Type=Integer,Description=\"Reference Allele Counts\">\n";
		print "##FORMAT=<ID=AD,Number=1,Type=Integer,Description=\"Alternative Allele Counts\">\n";
		print "##FORMAT=<ID=RO,Number=1,Type=Float,Description=\"Ratio of RD and AD\">\n";
		print "##FORMAT=<ID=MA,Number=1,Type=Integer,Description=\"Multiple Alternative Alleles\">\n";
		print "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\t$sample\n";
		next;
	}
	if($_=~/INDEL/){next;}  # 1. indel 
	@line=split(/\t/,$_);
	if($line[4] eq "X"){next;} # 2. no alternative alleles
	(@infos)=($_=~/^.*?DP=(\d+);I16=(\d+),(\d+),(\d+),(\d+).*/);
	# $infos[0]=DP, $infos[1,2]=ref count, $infos[3,4]=alt count
	if($infos[0]<=$dp_cutoff) {next;}
	$alt=$infos[3]+$infos[4];
	if( $alt<=$alt_cutoff){next;}
	$ref=$infos[1]+$infos[2];
	$ratio=sprintf("%.3f", $alt/($ref+$alt));
	if(($ref+$alt)<100){$rcf=$r_cutoff;}
	else{ $rcf=$r_cutoff2;}
	if( $ratio <= $rcf) {next;}
	$new_info="DP=".$infos[0].";RD=".$ref.";AD=".$alt.";RO=".$ratio;
	$line[4]=~s/,X//;
	$line[4]=substr($line[4],0,1); # put only the first alternative allele as the genotype of alt. alleles.
	if(length($line[4]) >1) {$new_info.=";MA=1";} # multiple alt. allele;
	else {$new_info.=";MA=0";}
	print join("\t",@line[0..6]),"\t.\tDP:RD:AD:RO:MA\t$new_info\n";		 
	 
	
}
