#!/bin/bash
### baheti.saurabh@mayo.edu
### Saurabh Baheti
### last updated: NOV 07 2012

if [ $# != 7 ]
then
	echo -e "script to mergeing the BAM files\nUsage: ./MergeBAMs.sh <path/to/input BAM file> </path/to/output BAM file> <sample name> </path/to/temp directory> <configuraion file></path/to/log directory><flag to delete the input file>"
	exit 1;
else
	set -x
	START=$(date +%s)
	inbam=$1 
	output_bam=$2
	sample=$3
	tmp_dir=$4 
	config=$5
	log_dir=$6
	flag=`echo $7 | tr "[A-Z]" "[a-z]"`
	
	picard=$( cat $config | grep '^PICARD=' | sed -e '/PICARD=/s///g')
	samtools=$( cat $config | grep '^SAMTOOLS=' | sed -e '/SAMTOOLS=/s///g')
	java=$( cat $config | grep '^JAVA=' | sed -e '/JAVA=/s///g')
	mem=$( cat $config | grep '^JVM_MEM=' |sed -e '/JVM_MEM=/s///g')	

	$java/java $mem -jar $picard/MergeSamFiles.jar \
	$inbam OUTPUT=$output_bam \
	TMP_DIR=$tmp_dir \
	CREATE_INDEX=true ASSUME_SORTED=true \
	VALIDATION_STRINGENCY=SILENT > $log_dir/$sample.merge.log 2>&1
	file=`echo $output_bam | sed -e 's/\(.*\)..../\1/'`
	mv $file.bai $output_bam.bai
	
	if [ $flag == "yes" ]
	then
		for bam in `echo $inbam | tr " " "\n" | sed -e '/INPUT=/s///g'`
		do
			rm $bam
		done
	fi
	END=$(date +%s)
	DIFF=$(( $END - $START ))
	echo "Merging the BAMs for $sample took $DIFF seconds"  
fi
