#!/bin/bash

########################################################
######  WRAPPER SCRIPT FOR CIRCRNA DETECTION

######          Program:                        circseq_wrapper.sh
######          Date:                           01/11/2016
######          Summary:                        Runs circRNA detection and BLAT filter
########################################################

if [ $# != 1 ]
then
        echo -e "Usage: Wrapper for circRNA detection\n wrapper.circRNA.sh \n
        1. full path to config file\n"
else
	set -x
	START=`date`
	echo `date`
	config=$1

	start_date=$(echo $START | tr " " "_")

	qsub=$( cat $config | grep -w '^SGE' | cut -d '=' -f2)
	queue=$( cat $config | grep -w '^QUEUE' | cut -d '=' -f2)
	circ_dir=$( cat $config | grep -w '^CIRC_DIR' | cut -d '=' -f2)
	email=$( cat $config | grep -w '^EMAIL' | cut -d '=' -f2)
	script_path=$( cat $config | grep -w '^WORKFLOW_PATH' | cut -d '=' -f2)
	threads=$( cat $config | grep -w '^THREADS' | cut -d '=' -f2)
	samples=$( cat $config | grep -w '^SAMPLENAMES' | cut -d '=' -f2)

	## convert : into array items
        sampleNames=$( echo $samples | tr ":" "\n" )
        i=1
        for sample in $sampleNames
        do
                sampleArray[$i]=$sample
                let i=i+1
        done
	num_samples=${#sampleArray[@]}

	mkdir $circ_dir/logs
	
	#### STEP1: circRNA detection module	
	for i in `seq 1 $num_samples`; do $qsub/qsub -V -wd $circ_dir/logs -m ae -M $email -l h_vmem=30G -l h_stack=10M -pe threaded $threads -q $queue -N circRNA_detection.${sampleArray[$i]} $script_path/circRNA_detection.sh $config ${sampleArray[$i]}; done


	### STEP2: BLAT filter module
	for i in `seq 1 $num_samples`; do $qsub/qsub -V -wd $circ_dir/logs -m ae -M $email -l h_vmem=6G -l h_stack=10M -q $queue -N BLAT_filter.${sampleArray[$i]} -hold_jid circRNA_detection.${sampleArray[$i]} $script_path/BLAT_filter.sh $config ${sampleArray[$i]} $start_date ; done
	
	echo `date`
fi
