use List::MoreUtils qw(uniq);
use strict;
use warnings;

if (scalar(@ARGV) != 3)	
{
	die ( "Usage:\ncircRNAs_annotation.pl <input BED file with all entries> <input BED file after intersection with Exon Start,Exon End etc. bed files> <Ouput file with annotation>\n" );
}

my %hash1=();
my %hash2=();

open (FIRST,"$ARGV[0]");
while (my $line = <FIRST>)
{
	next if ($line =~ m/n_reads/);
	chomp $line;
	my @array = split('\t',$line);
	my $uniq = join ("#", $array[0], $array[1], $array[2],$array[3]);
	$hash1{$uniq} = join ("\t",@array);
}
close FIRST;

open (SECOND,"$ARGV[1]");
while(my $line = <SECOND>)	
{
	chomp $line;
	my @array = split('\t',$line);
	my $num = scalar @array;
	my $uniq = join ("#", $array[0], $array[1], $array[2],$array[3]);
	my $merged_value = join ("#",$array[$num-3], $array[$num-2], $array[$num-1]);
	push( @{$hash2{$uniq}},$merged_value);
}
close SECOND;

open (OUT, ">$ARGV[2]");
open (FIRST,"$ARGV[0]");
my $firstLine = <FIRST>;
chomp $firstLine;
print OUT "$firstLine\tcircRNA_Gene_Annotation\tcircRNA_Exon_Annotation\tExons_spanning_circRNA\tGene_Symbol\tTranscript_Symbol\n";
close FIRST;

foreach my $key (sort keys %hash1)	
{
if (defined $hash2{$key})
{
	my $count=0;
	my @all=@{$hash2{$key}};
	$count = scalar @all;
	my @exon="";my @gene="";my @trans="";
	for (my $i=0; $i < $count; $i++)
	{
		my @tmp = split ("#",$all[$i]);
		push(@exon,$tmp[0]);
		push (@gene,$tmp[1]);
		push (@trans,$tmp[2]); 
	}
	my @uniq_exon = uniq @exon;
	my @uniq_gene = uniq @gene;
	my @uniq_trans = uniq @trans;
	my $ex = join (";", @uniq_exon);
	my $gen = join (";", @uniq_gene);
	my $tran = join (";", @uniq_trans);
	$ex =~ s/^\;//; 
	$gen =~ s/^\;//; 
	$tran =~ s/^\;//;
	my $gene_annot=""; my $exon_annot="";
	if ($ex =~ "End")
	{
		$exon_annot = "exon-exon_boundary";
	}
	elsif ($ex =~ /Start/)
	{
		$exon_annot = "exon-exon_boundary";
	}
	else
	{
		$exon_annot = "within_exon";
	}
	my $num = scalar @uniq_gene;
	if (($num-1) == 1)
	{
		$gene_annot = "intra_gene";
	}
	elsif (($num-1) > 1)
	{
		$gene_annot = "inter_gene";
	}
	print OUT "$hash1{$key}\t$gene_annot\t$exon_annot\t$ex\t$gen\t$tran\n";
}
else
{
	print OUT "$hash1{$key}\tNA\tNA\tNA\tNA\tNA\n";
}	
}
close OUT;



