#!/bin/sh

if [ $# != 3 ]
then
	echo -e "Usage: script to run blat\n $0 <config file, full path> <sample name> <path to tmp dir>"
else
    set -x
    echo `date`

	config=$1
	sample=$2
	tmp_dir=$3
	file=$SGE_TASK_ID

	blat=$( cat $config | grep -w '^BLAT' | cut -d '=' -f2)
	blat_ref=$( cat $config | grep -w '^BLAT_REF' | cut -d '=' -f2)

	$blat/blat -minScore=20 -tileSize=6 -minIdentity=100 $blat_ref $tmp_dir/$file.txt -out=blast8 $tmp_dir/$file.out.txt
	linecount=`wc -l $tmp_dir/$file.out.txt | cut -f1 -d " "`

	if [ "$linecount" -lt 2 ]
	then
		rm $tmp_dir/$file.out.txt
	fi
	echo `date`
fi
