#!/usr/bin/perl -w
# wig_norm.pl
# Author: Huihuang Yan, 9/25/2012, 02/01/2013
# This script does normalization based on total mapped reads
# normalized to 10M number of total mapped reads 


use strict;
use File::Basename;

my %args=@ARGV;
my $infile = $args{'-i'};
my $count = $args{'-c'};
my $method = $args{'-m'}||"total";
my $dir = $args{'-d'};
my $filename=basename($infile, ".raw.wig");

my $outfile = $args{'-o'}||$filename."_".$method."_based_norm.wig";

my $usage = "$0 -d DirName -i WigInFile -c ReadsCount [-m NormMethod] [-o OutFile]\n";
print "$usage\n" unless $infile;

open (IN, "<$dir/$infile") || die  "Can't open raw wig file $infile\n";
open (OUT, ">$dir/$outfile")|| die "Can't open output file $outfile\n";

while(<IN>) {
        chomp;
       @_=split;

if ($_[0] =~ /^\d+/ && $_[1] >= 1) {
        printf OUT "%d\t%.2f\n",$_[0],($_[1]/$count)*10000000;
}

    elsif (/^track/) {
        s/raw/norm/g;
        print OUT $_,"\n";
}

    elsif (/span/) {
        print OUT $_,"\n";
}

}

