#!/bin/bash
## Raymond Moore
## 7.30.13
shopt -s nocasematch

SCRIPTDIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )" ### Will always find source dir, from this file.
RSYNC_URL="http://dnode0.mayo.edu/cgi-cim/rsync-agtc-subdir.pl"
#HSRWEB_URL="http://hsrwww.mayo.edu/bsi/projects/bic"
HSRWEB_URL="http://bucky/data_delivery/bic"
RCF_URL="ftp://rcfisinl1-212/delivery"
CWD=$(pwd)
read -p "$CWD is a WORK_DIR? " OPT
if [[ !($OPT == "y" || $OPT == "") ]]
then
	echo -e "Incorrect Directory: Quit!\n"
	exit 1
fi

##########
###  Send to NGS portal
##########
RUN_INFO=`ls delivery/run_*`
if [ ! $RUN_INFO ]
then
	echo -e "\n\nERROR : run_info file was not found";
	exit 1;
fi

read -p "Submit to NGS Portal?" OPT
if [[ ($OPT == "y" || $OPT == "") ]]
then
	#FIRSTRECORD=`ls -ltr logs/ | head -2 | tail -1 | cut -f10-12 -d' '`
	#echo -e "\tFirst Record: $LASTRECORD"
	GRP_INDEX=`ls -tr logs/ | head -2 | tail -1 | cut -d'.' -f6 | sed s/PN//`
	echo -e "\tProject index: $GRP_INDEX"

	$SCRIPTDIR/dashboard.sh -r $RUN_INFO -s Delivered -c
fi


PI=`pwd | cut -d'/' -f5`
for TDIR in `pwd | tr '/' '\n'`
	do
	NUM=`echo $TDIR | grep -o '_' | wc -l`
	if [ $NUM -gt 2 ];then RUNID=$TDIR; fi
	LASTDIR=$TDIR
done


read -p "Deliver to RCF?" OPT
if [[ ($OPT == "y" || $OPT == "") ]]
then
	#######
	## Check to Ensure moving files to correct RCF place
	#######

	TORCF="/data2/delivery/$PI/$RUNID/secondary/$LASTDIR/"
	echo -e "\t\e[1;32m $TORCF \e[0m"
	read -p "Send this RCF directory?" OPT
	if [[ !($OPT == "y" || $OPT == "") ]]
	then	
		read -p "  Enter your own directory?" OPT2
		if [[ !($OPT2 == "y" || $OPT2 == "") ]]
		then
			echo "Quit!\n"; exit 1; 
		else
			read -p "-> Enter PI: " PI
			read -p "-> Enter RUNID: " RUNID
			read -p "-> Enter LASTDIR: " LASTDIR
			TORCF="/data2/delivery/$PI/$RUNID/secondary/$LASTDIR/"
			echo -e "\t\e[1;32m $TORCF \e[0m"
			
			read -p "Is this the correct directory?" OPT
			if [[ ($OPT == "y" || $OPT == "") ]]; then	mkdir -p $TORCF; else exit 1; fi
		fi
	fi

	### If directory doesn't exist, make it.
	if [ ! -d $TORCF ]; then mkdir -p $TORCF; fi

	#########
	## Prepare and Move Files to RCF
	#########
	tar -zcf delivery/logs.tar.gz logs/
	rm -R logs/

	### Add check not to deliver if files are already there.

	printf "\x1b[5mMoving Files...\x1b[25m"
	cp -R $CWD/delivery/* $TORCF
	echo -e "\n"
	### automate the Rsync, ruby webby might work.
	echo -e "Please go to Rsync: \e[1;36m $RSYNC_URL \e[0m"
	echo -e "\n"

fi	
	

read -p "Deliver to HSR?" OPT
if [[ ($OPT == "y" || $OPT == "") ]]
then	
	
	############
	## Prepare to Send delivery small files to HRS server
	############
	MLAN_ID=$(whoami)
	echo $MLAN_ID
	echo "Please provide your Mayo password:"
	read -s PSWD
	printf "username=MFAD\\$MLAN_ID\npassword=$PSWD\n" > ~/ACESSKEY

	read -p "The HSR directory MUST already exist, Please enter the s##.keyword name here: " HSR_DIR
	if [[ $HSR_DIR == "" ]]; then	echo "INVALID!\n"; exit 1; fi

	HSRDELIVER="apps/data_delivery/bsi/bic/${PI}/${HSR_DIR}"
	echo -e "\t\e[1;32m ${HSRDELIVER}/${LASTDIR} \e[0m"
	read -p "Send this HSR directory?" OPT 
	if [[ !($OPT == "y" || $OPT == "") ]]; then echo "QUIT OUT!\n"; exit 1; fi

	cd delivery/
	ls | grep -v "mapout" | grep -v "bedgraph" | grep -v '.txt' | grep -v '.gz'  > list.txt
	tar -cf mytarfile.tar -T list.txt 
	echo -e "\n\n\n"

	smbclient "//hsrntfs/projects" \
		-A ~/ACESSKEY \
		-c "cd $HSRDELIVER; mkdir $LASTDIR; cd $LASTDIR;" \
		-Tx mytarfile.tar

	rm ~/ACESSKEY
fi



echo -e "\nCopy & Paste into your email:\n\n\n"

echo -e "Flowcell: $RUNID"
echo -e "The Deliverable Results:\n  \e[1;36m$HSRWEB_URL/$PI/$HSR_DIR/$LASTDIR \e[0m \n"
echo -e "The Workflow Analysis Output (Alignment & Large Files):\n  \e[1;36m$RCF_URL/$PI/$RUNID/secondary/$LASTDIR/ \e[0m \n\n"

