#!/usr/bin/perl
# Reads bam.size.txt file of format
# Column 1: Fragment size
# Column 2: Number of pairs 
# Prints bin, size_start, size_end, numpairs bin sum and percentage of total per bin
# Usage example: perl bin_sum_ratio.pl /home/m110443/projects/chipseq2/test/9_-_Hela_-_vehicle_H3K9me3.FCC1657ACXX_L4_R1_IATCACG.PE.U12.dedup.s1.bam.size.txt

open(IN, $ARGV[0]); while(<IN>){ ($fragsize, $numpairs) = split(/[\t\n]/);

	while($fragsize > $ubound){ $lbound += 10; $ubound += 10; $bin++; }	

	$sum[$bin] += $numpairs; $sum += $numpairs;	

}close(IN);

print "Bin\tSize_start\tSize_end\tNumber_pairs\tPercentage\n";

for $bin (1 .. 50) { print $bin ."\t". ($bin*10-9) ."\t". ($bin*10) ."\t". ($sum[$bin] | 0) ."\t". (sprintf "%.2f", (100*$sum[$bin]/$sum)) ."\n"; }

