#!/usr/bin/perl -w
## Raymond Moore 7.30.13
### Create IGV session for NGS visualization
use Data::Dumper;

open(RUN, "<", $ARGV[0]) or die $!;
#my @run_vars = grep {!/^(\s+|1)$/} map{ (split /\=/, $_ ) unless $_=~/^#/ } (<RUN>); 
################ Need to fix this....CEAS args have '=' in them!
my %run_vars = grep {!/^(\s+|1)$/} map{ (split /\=/, $_ ) unless $_=~/^(#|\>)/ } (<RUN>); 
chomp(%run_vars);  ##required because values retain "\n"
print "$run_vars{'TOOL_INFO'}\n";

open(TOOL, "<", $run_vars{'TOOL_INFO'}) or die $!;
my %tool_vars = grep {!/^(\s+|1)$/} map{ (split /\=/, $_ ) unless $_=~/^#/ } (<TOOL>); 
chomp(%tool_vars);  ##required because values retain "\n"
my $outdir = $run_vars{'WORK_DIR'};
my $lastDIR = (split /\//, $outdir)[-1];
open OUT, ">$outdir/delivery/igv_session.xml" or die $!; 


if($run_vars{'PEAK_CALLER'} eq "macs2idr"){
	## Capture ${MACS2_OUTDIR}"/"$( echo $SEQ1NAME ).${SEQ_TYPE}_r1pr0_macs2_peaks.bed
	chomp(@beds=`ls $outdir/macs2out/*r1pr0_macs2_peaks.bed`);

}elsif($run_vars{'PEAK_CALLER'} eq "macs2noidr"){
	## Capture ${MACS2_OUTDIR}"/"$( echo $SEQ1NAME ).${SEQ_TYPE}_macs2_peaks.bed
  	chomp(@beds = `ls $outdir/macs2out/*macs2_peaks.bed`);

}elsif($run_vars{'PEAK_CALLER'} eq "sicer"){
	## Capture ${SICER_OUTDIR}"/"$( echo $SEQ1NAME ).${SEQ_TYPE}.${FILTER_TYPE}.${REMOVE_DUP}.s1-W*-G*-FDR*[0-9]-island.bed
	chomp(@beds = `ls $outdir/sicerout/*s1-W*-G*-FDR*[0-9]-island.bed`);
}

chomp(@wigs = `ls $outdir/mapout/*tdf`);

print OUT "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";
print OUT "<Global genome=\"".$run_vars{'GENOMEBUILD'}."\" locus=\"All\" version=\"4\">\n";
print OUT "\t<Resources>\n";

foreach $bd (@beds){
	@divName=split(/\//, $bd);
	$bedfile=pop(@divName);
	$beddir=pop(@divName);
	my @futurePath=($tool_vars{'IGV_LINK'},$run_vars{'PI'},$run_vars{'RUNID'},'secondary',$lastDIR,$beddir,$bedfile);
	#print join("/", @futurePath)."\n";
	print OUT "\t\t<Resource name=\"".$bedfile."\" path=\"".join("/", @futurePath)."\" />\n";
}

foreach $wg (@wigs){
	#print "$wg\n";
	@divName=split(/\//, $wg);
	$bedfile=pop(@divName);
	$beddir=pop(@divName);
	my @futurePath=($tool_vars{'IGV_LINK'},$run_vars{'PI'},$run_vars{'RUNID'},'secondary',$lastDIR,$beddir,$bedfile);
	#print join("/", @futurePath)."\n\n";
	print OUT "\t\t<Resource name=\"".$bedfile."\" path=\"".join("/", @futurePath)."\" />\n";
}
	   
print OUT "\n\t</Resources>\n</Global>";
close RUN; close TOOL; close OUT;

