####fun.R


library(qvalue)

###get pvalues

bt=function(my_v) {

my_pvalue=binom.test(my_v[1], my_v[2], my_v[3], alternative="greater")$p.value

return(my_pvalue)
}



###correct pvalues

get_correction=function(infile, method="qvalue") {

my_great_out=read.delim(infile, sep="\t", header=F)

my_data=my_great_out[,c(5,4,7)]


#############
my_raw_pvalue=signif(apply(my_data,1,bt),3)
my_raw_pvalue_df=data.frame(my_great_out, my_raw_pvalue)


#######pvalue corrections
if(method=="qvalue") {

my_qvalue=qvalue(p=my_raw_pvalue_df[,8], lambda=seq(0, 0.9, 0.05), pi0="bootstrap")
my_table=data.frame(my_raw_pvalue_df, signif(my_qvalue$qvalues,3))

}


else {

my_adj_pvalues=p.adjust(my_raw_pvalue_df[,8], method="BH")

my_table=data.frame(my_raw_pvalue_df, signif(my_adj_pvalues,3))

}


colnames(my_table)=c("ID", "Ontology", "Term", "Total_hits", "Region_hits", "Size", "Genome_fraction", "Raw_pvalues", "Corrected_pvalues")

my_table_order=my_table[order(my_table$Corrected_pvalues, decreasing=F),]


out_file=paste(infile, "bt_out.txt", sep="_")

write.table(my_table_order, out_file, sep="\t", row.names=F, quote=F)

}


## SigTest.R

cat("-- reading arguments from ......\n", sep = "");
cmd_args = commandArgs(trailingOnly=TRUE);

for (arg in cmd_args) {
cat("  ", arg, "\n", sep="")
}


## parse output
my_infile=unlist(strsplit(cmd_args[1], "="))[2]
my_method=unlist(strsplit(cmd_args[2], "="))[2]

print(my_infile)
print(my_method)

get_correction(infile=my_infile, method=my_method)


