## Tool Paths
SCRIPT_PATH=/home/roue/mirdeep_install/CAP-miRNA/scripts
MIRDEEP2_PATH=/home/roue/ex/bin
BOWTIE_PATH=/home/roue/ex/bin
RANDFOLD_PATH=/home/roue/ex/bin
SQUID_PATH=/home/roue/ex/bin
VIENNA_PATH=/home/roue/ex/bin
PDFAPI2_PM_PATH=/home/roue/ex/lib/perl5
JAVA_PATH=/usr/local/bin
NGS_PORTAL_PATH=/projects/bsi/bictools/apps/misc/ngs_dashboard/2.0
PICARD_PATH=/home/roue/ex/bin
FASTQC_PATH=/home/roue/ex/bin
CUTADAPT_PATH=/home/roue/ex/bin
SAMTOOLS_PATH=/home/roue/ex/bin
BEDTOOLS_PATH=/home/roue/ex/bin
GATK_JAR=
VCFTOOLS_PATH=/home/roue/ex/bin
VCFTOOLS_PERLLIB=/home/roue/ex/lib/perl5/site_perl
HTSEQ_PATH=/home/roue/ex/bin
HTSEQ_LIB_PATH=/home/roue/ex/lib/python2.7/site-packages
PYTHON_PATH=/usr/bin

## Tool Parameters
CUTADAPT_PARAMS=-b AATCTCGTATGCCGTCTTCTGCTTGC -O 3 -m 17 -f fastq
MAPPER_PARAMS=-e -h -q -m -r 5 -u -v -o 4
MIRDEEP2_PARAMS=-P -t Human
MIRDEEP2_CLOSE_SPECIES=none
QUANTIFIER_PARAMS=-P -W
BOWTIE_PARAMS=-p 4 -S -q -n 1 -e 80 -l 30 -a -m 5 --best --strata
ADDORREPLACEREADGROUPS_PARAMS=MAX_RECORDS_IN_RAM=100000 VALIDATION_STRINGENCY=SILENT RGLB=hg19 RGCN=Mayo RGPL=Illumina 
SORTSAM_PARAMS=MAX_RECORDS_IN_RAM=1800000 VALIDATION_STRINGENCY=SILENT
PRINTREADS_PARAMS=-rf ReassignOneMappingQuality -RMQF 255 -RMQT 60
UNIFIEDGENOTYPER_PARAMS=-glm SNP -dcov 1000
HTSEQ_PARAMS=-m intersection-nonempty -q -t exon -s no
QUEUE=1-day

## Reference Files
REF_GENOME=/home/roue/mirdeep_install/CAP-miRNA/small_ref/hg19_chr1.fa
BOWTIE_REF=/home/roue/mirdeep_install/CAP-miRNA/small_ref/hg19_chr1
MIRBASE_HAIRPIN=/home/roue/mirdeep_install/CAP-miRNA/small_ref/hairpin.hsa.dna.fa
MIRBASE_MATURE=/home/roue/mirdeep_install/CAP-miRNA/small_ref/mature.hsa.dna.fa
MIRBASE_GFF=/home/roue/mirdeep_install/CAP-miRNA/small_ref/mirbase.v19.hsa.chr1.gff3
GENCODE_GTF=/home/roue/mirdeep_install/CAP-miRNA/small_ref/gencode.v18.annotation.chr1.gtf

## Memory Parameters
# QSUB
REFERENCE_INDEXES_MEM=-l h_vmem=3G -l h_stack=10M
CUTADAPT_MEM=-l h_vmem=2G -l h_stack=10M
FASTQC_MEM=-l h_vmem=3G -l h_stack=10M
BAMS_MEM=-l h_vmem=750M -l h_stack=10M
MIRDEEP2_MAPPER_MEM=-l h_vmem=512M -l h_stack=10M
MIRDEEP2_MEM=-l h_vmem=2G -l h_stack=10M
VARIANTS_MEM=-l h_vmem=3G -l h_stack=10M
EXPRESSION_REPORTS_MEM=-l h_vmem=1G -l h_stack=10M
DIFF_EXPRESSION_MEM=-l h_vmem=2G -l h_stack=10M
GENCODE_CLASSIFICATION_MEM=-l h_vmem=3G -l h_stack=10M
SAMPLE_SUMMARY_MEM=-l h_vmem=1G -l h_stack=10M
MAIN_DOC_MEM=-l h_vmem=1G -l h_stack=10M
# JVM
CREATEDICTIONARY_JVM_MEM=-Xmx512m -Xms512m
ADDORREPLACEREADGROUPS_JVM_MEM=-Xmx256m -Xms256m
SORTSAM_JVM_MEM=-Xmx1g -Xms512m
UNIFIEDGENOTYPER_JVM_MEM=-Xmx256m -Xms256m
