/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import edu.mayo.cli.ArgumentDefinition;
import edu.mayo.cli.CLIInitialization;
import edu.mayo.cli.CLIOption;
import edu.mayo.cli.util.CLIConstants;
import edu.mayo.cli.util.OptionsUtil;
import edu.mayo.cli.util.PropertiesUtil;
import edu.mayo.cli.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class CLIUsageHandler {
    private String version;
    private String scriptName;
    private String pluginName;
    private String[] cmdArgs;
    private Options opts;
    private List<ArgumentDefinition> argDefs;
    private static final String englishRules = "< A,a < B,b < C,c < D,d < E,e < F,f < G,g < H,h < I,i < J,j < K,k < L,l,lf < M,m < N,n < O,o < P,p < Q,q < R,r < S,s < T,t < U,u < V,v < W,w < X,x < Y,y < Z,z";
    private RuleBasedCollator collator;
    private boolean mIsSystemExitEnabled = true;
    protected static Comparator<Option> mShortOptionComparator = new Comparator<Option>(){

        @Override
        public int compare(Option opt1, Option opt2) {
            return opt1.getOpt().compareToIgnoreCase(opt2.getOpt());
        }
    };
    protected static Comparator<Option> mLongOptionComparator = new Comparator<Option>(){

        @Override
        public int compare(Option opt1, Option opt2) {
            return opt1.getLongOpt().compareToIgnoreCase(opt2.getLongOpt());
        }
    };

    public CLIUsageHandler(CLIInitialization initialization) throws ParseException {
        this.version = initialization.getVersion();
        this.scriptName = initialization.getScriptName();
        this.cmdArgs = initialization.getCmdArgs();
        this.pluginName = initialization.getPluginName();
        this.opts = initialization.getOptions();
        this.argDefs = initialization.getArgumentDefinitions();
        this.collator = new RuleBasedCollator(englishRules);
    }

    public String getVersionText() {
        return this.version;
    }

    public boolean isVersionFlagUsed() {
        return this.isOptionUsed(OptionsUtil.getOptionByLongName(this.opts, "version"));
    }

    public boolean isHelpFlagUsed() {
        return this.isOptionUsed(OptionsUtil.getOptionByLongName(this.opts, "help"));
    }

    public boolean isLogFlagUsed() {
        return this.isOptionUsed(OptionsUtil.getOptionByLongName(this.opts, "log"));
    }

    public boolean isLogFileFlagUsed() {
        return this.isOptionUsed(OptionsUtil.getOptionByLongName(this.opts, "logfile"));
    }

    private boolean isOptionUsed(Option o) {
        for (String arg : this.cmdArgs) {
            if (!arg.equals("-" + o.getOpt()) && !arg.equals("--" + o.getLongOpt())) continue;
            return true;
        }
        return false;
    }

    public String getHelpText() throws IOException, ClassNotFoundException {
        String optionalOptionsText;
        StringWriter help = new StringWriter();
        PrintWriter writer = new PrintWriter(help);
        ResourceBundle bundle = PropertiesUtil.getBundle(this.pluginName);
        String shortDesc = StringUtils.indent(StringUtils.wrap(this.scriptName + " -- " + bundle.getString("short.description"), 94), 1);
        String longDesc = StringUtils.indent(StringUtils.wrap(bundle.getString("long.description"), 94), 1);
        HashSet<Option> optionsAlreadyAdded = new HashSet<Option>();
        writer.println();
        writer.println("NAME");
        writer.println(shortDesc);
        writer.println();
        writer.println("SYNOPSIS");
        writer.println("\t" + this.getSynopsisText());
        writer.println();
        writer.println("DESCRIPTION");
        writer.println(longDesc);
        writer.println();
        String argText = this.getArgumentsText();
        if (argText.length() > 0) {
            writer.println(argText);
        }
        writer.println("OPTIONS");
        writer.println();
        String requiredOptionsText = this.getOptionsText(true, true, optionsAlreadyAdded);
        if (requiredOptionsText.length() > 0) {
            writer.println("Required:");
            writer.println();
            writer.println(StringUtils.indent(requiredOptionsText, 1));
            writer.println();
        }
        if ((optionalOptionsText = this.getOptionsText(false, true, optionsAlreadyAdded)).length() > 0) {
            writer.println("Optional:");
            writer.println();
            writer.println(StringUtils.indent(optionalOptionsText, 1));
            writer.println();
        }
        writer.print(this.getExamplesText(bundle));
        return help.toString();
    }

    protected String getSynopsisText() throws IOException {
        String argsStr = "";
        for (ArgumentDefinition arg : this.argDefs) {
            argsStr = argsStr + " " + arg.getName() + (arg.getIsVariableNumberOfArgs() ? " ..." : "");
        }
        HashSet<Option> optionsAlreadyAdded = new HashSet<Option>();
        String requiredFlags = this.getOptionsText(true, false, optionsAlreadyAdded);
        String optionalFlags = this.getOptionsText(false, false, optionsAlreadyAdded);
        return this.scriptName + argsStr + CLIConstants.NEW_LINE + (requiredFlags.length() > 0 ? StringUtils.indent(requiredFlags, 2) + CLIConstants.NEW_LINE : "") + (optionalFlags.length() > 0 ? StringUtils.indent(optionalFlags, 2) : "");
    }

    private List<Option> getOptions(boolean isGetRequiredOptions) {
        ArrayList<Option> options = new ArrayList<Option>();
        Collection allOptions = this.opts.getOptions();
        for (Option option : allOptions) {
            boolean isRequiredThruGroup;
            boolean isRequired = isGetRequiredOptions == option.isRequired();
            OptionGroup optionGroup = this.opts.getOptionGroup(option);
            boolean bl = isRequiredThruGroup = optionGroup != null && isGetRequiredOptions == optionGroup.isRequired();
            if (!isRequired && !isRequiredThruGroup) continue;
            options.add(option);
        }
        return options;
    }

    public String getOptionsText(boolean isRequired, boolean isVerbose, Set<Option> optionsAlreadyAdded) throws IOException {
        StringWriter optionsText = new StringWriter();
        PrintWriter writer = new PrintWriter(optionsText);
        List<Option> optionList = this.getOptions(isRequired);
        Collections.sort(optionList, isVerbose ? mShortOptionComparator : mLongOptionComparator);
        for (int i = 0; i < optionList.size(); ++i) {
            CLIOption option = (CLIOption)optionList.get(i);
            if (optionsAlreadyAdded.contains((Object)option) || option.isHidden()) continue;
            if (i > 0 && isVerbose) {
                writer.println();
            }
            if (this.isOptionInGroup(option)) {
                List<Option> optionsInGroup = this.getOptionsInGroup(option);
                if (isVerbose) {
                    writer.println(this.getOptionGroupText_verbose(optionsInGroup, isRequired));
                } else {
                    writer.println(this.getOptionGroupText_synopsis(optionsInGroup, isRequired));
                }
                optionsAlreadyAdded.addAll(optionsInGroup);
                continue;
            }
            if (isVerbose) {
                writer.println(this.getOptionText_verbose(option, isRequired));
            } else {
                writer.println(this.getOptionText_synopsis(option, isRequired));
            }
            optionsAlreadyAdded.add(option);
        }
        return optionsText.toString();
    }

    private boolean isOptionInGroup(Option option) {
        OptionGroup optionGroup = this.opts.getOptionGroup(option);
        return optionGroup != null;
    }

    private List<Option> getOptionsInGroup(CLIOption option) {
        ArrayList<Option> optionList = new ArrayList<Option>();
        OptionGroup optionGroup = this.opts.getOptionGroup((Option)option);
        if (optionGroup != null) {
            optionList.addAll(optionGroup.getOptions());
        }
        return optionList;
    }

    private String getOptionText_verbose(CLIOption option, boolean isRequired) throws IOException {
        String argStr;
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        String string = argStr = option.hasArg() ? " <" + option.getArgName() + ">" : "";
        if (option.getOpt().equals(option.getLongOpt())) {
            pWtr.println(String.format("--%s%s", option.getLongOpt(), argStr));
        } else {
            pWtr.println(String.format("-%s, --%s%s", option.getOpt(), option.getLongOpt(), argStr));
        }
        String description = StringUtils.indent(StringUtils.wrap(option.getDescription(), 94), 1);
        pWtr.print(description);
        pWtr.close();
        return sWtr.toString();
    }

    private String getOptionText_synopsis(CLIOption option, boolean isRequired) {
        String argStr = option.hasArg() ? " <" + option.getArgName() + ">" : "";
        String format = "--%s%s";
        if (!isRequired) {
            format = "[" + format + "]";
        }
        return String.format(format, option.getLongOpt(), argStr);
    }

    private String getOptionGroupText_verbose(List<Option> optionsInGroup, boolean isRequired) throws IOException {
        Collections.sort(optionsInGroup, mShortOptionComparator);
        String synopsisLine = this.getOptionGroupText_synopsis(optionsInGroup, isRequired);
        String flagsForDescription = this.getOptionGroupText_description(optionsInGroup);
        return synopsisLine.replaceAll("\\[", "").replaceAll("\\]", "") + CLIConstants.NEW_LINE + StringUtils.indent(flagsForDescription, 1);
    }

    private String getOptionGroupText_synopsis(List<Option> optionsInGroup, boolean isRequired) {
        Collections.sort(optionsInGroup, mShortOptionComparator);
        StringBuilder synopsisLine = new StringBuilder();
        for (int i = 0; i < optionsInGroup.size(); ++i) {
            if (i > 0) {
                synopsisLine.append("  OR  ");
            }
            synopsisLine.append(this.getOptionText_synopsis((CLIOption)optionsInGroup.get(i), isRequired));
        }
        return synopsisLine.toString();
    }

    private String getOptionGroupText_description(List<Option> optionsInGroup) throws IOException {
        StringBuilder descText = new StringBuilder();
        for (int i = 0; i < optionsInGroup.size(); ++i) {
            if (i > 0) {
                descText.append(CLIConstants.NEW_LINE + CLIConstants.NEW_LINE);
            }
            descText.append(this.getOptionText_verbose((CLIOption)optionsInGroup.get(i), true));
        }
        return descText.toString();
    }

    private String getExamplesText(ResourceBundle bundle) throws IOException {
        StringWriter examplesText = new StringWriter();
        PrintWriter writer = new PrintWriter(examplesText);
        List<String> exampleKeysSorted = this.getExampleKeysSorted(bundle);
        for (int i = 0; i < exampleKeysSorted.size(); ++i) {
            if (i > 0) {
                writer.println();
            }
            writer.println("EXAMPLE");
            String example = StringUtils.indent(StringUtils.wrap(bundle.getString(exampleKeysSorted.get(i)), 94), 1);
            writer.println(example);
        }
        return examplesText.toString();
    }

    private List<String> getExampleKeysSorted(ResourceBundle bundle) {
        ArrayList<String> exampleKeys = new ArrayList<String>();
        for (String key : bundle.keySet()) {
            if (!key.startsWith("example.")) continue;
            exampleKeys.add(key);
        }
        Collections.sort(exampleKeys);
        return exampleKeys;
    }

    private String getArgumentsText() throws IOException {
        StringWriter argText = new StringWriter();
        PrintWriter writer = new PrintWriter(argText);
        if (this.argDefs.size() > 0) {
            writer.println(StringUtils.indent("The arguments are as follows:", 1));
            for (ArgumentDefinition argDef : this.argDefs) {
                writer.println();
                writer.println(StringUtils.indent(argDef.getName(), 1));
                writer.println(StringUtils.indent(StringUtils.wrap(argDef.getDescription(), 94), 2));
            }
        }
        return argText.toString();
    }
}

