/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.regex;

import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.regex.Pattern;
import org.biojava.utils.regex.PatternChecker;
import org.biojava.utils.regex.RegexException;

public class PatternFactory {
    private FiniteAlphabet alfa;
    private SymbolTokenization toke = null;
    private PatternChecker checker = null;

    PatternFactory(FiniteAlphabet alfa) {
        this.alfa = alfa;
        this.fetchTokenizer();
    }

    private void fetchTokenizer() {
        boolean gotCharTokenizer = false;
        try {
            this.toke = this.alfa.getTokenization("token");
            if (this.toke.getTokenType() == SymbolTokenization.CHARACTER) {
                gotCharTokenizer = true;
            }
        }
        catch (BioException bioException) {
            // empty catch block
        }
        if (!gotCharTokenizer) {
            CharacterTokenization cToke = new CharacterTokenization(this.alfa, true);
            char uniChar = '\ue000';
            Iterator<Symbol> symI = this.alfa.iterator();
            while (symI.hasNext()) {
                AtomicSymbol sym = (AtomicSymbol)symI.next();
                cToke.bindSymbol(sym, uniChar);
                uniChar = (char)(uniChar + '\u0001');
            }
            cToke.bindSymbol(AlphabetManager.getAllAmbiguitySymbol(this.alfa), '\uf8ff');
            cToke.bindSymbol(Alphabet.EMPTY_ALPHABET.getGapSymbol(), '~');
            cToke.bindSymbol(this.alfa.getGapSymbol(), '-');
            ((AbstractAlphabet)this.alfa).putTokenization("unicode", cToke);
            this.toke = cToke;
        }
    }

    public Pattern compile(String pattern) throws RegexException, IllegalAlphabetException {
        if (this.checker == null) {
            this.checker = new PatternChecker(this.alfa);
        }
        return new Pattern(pattern, this.checker, this.alfa);
    }

    public Pattern compile(String pattern, String label) throws RegexException, IllegalAlphabetException {
        if (this.checker == null) {
            this.checker = new PatternChecker(this.alfa);
        }
        return new Pattern(pattern, this.checker, this.alfa, label);
    }

    public char charValue(Symbol sym) throws IllegalSymbolException {
        return this.toke.tokenizeSymbol(sym).charAt(0);
    }

    public static PatternFactory makeFactory(FiniteAlphabet alfa) {
        return new PatternFactory(alfa);
    }
}

