/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.automata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.automata.FiniteAutomaton;
import org.biojava.utils.automata.NfaBuilder;

public class NfaSubModel
implements NfaBuilder {
    private NfaBuilder delegate;
    private Set nodes = new HashSet();
    private Set transitions = new HashSet();
    private FiniteAutomaton.Node start = null;
    private FiniteAutomaton.Node end = null;

    NfaSubModel(NfaBuilder delegate) {
        this.delegate = delegate;
        this.start = this.addNode(false);
        this.end = this.addNode(false);
    }

    @Override
    public FiniteAutomaton getAutomaton() {
        return this.delegate.getAutomaton();
    }

    @Override
    public FiniteAutomaton.Node getStart() {
        return this.start;
    }

    @Override
    public FiniteAutomaton.Node getEnd() {
        return this.end;
    }

    void setStart(FiniteAutomaton.Node start) {
        this.nodes.add(start);
        this.start = start;
    }

    void setEnd(FiniteAutomaton.Node end) {
        this.nodes.add(end);
        this.end = end;
    }

    @Override
    public FiniteAutomaton.Node addNode(boolean isTerminal) {
        FiniteAutomaton.Node newNode = this.delegate.addNode(isTerminal);
        this.nodes.add(newNode);
        return newNode;
    }

    @Override
    public FiniteAutomaton.Transition addTransition(FiniteAutomaton.Node start, FiniteAutomaton.Node end, Symbol sym) {
        FiniteAutomaton.Transition newTransition = this.delegate.addTransition(start, end, sym);
        this.transitions.add(newTransition);
        return newTransition;
    }

    @Override
    public FiniteAutomaton.Transition addEpsilonTransition(FiniteAutomaton.Node start, FiniteAutomaton.Node end) {
        FiniteAutomaton.Transition newTransition = this.delegate.addEpsilonTransition(start, end);
        this.transitions.add(newTransition);
        return newTransition;
    }

    @Override
    public FiniteAutomaton.Transition addLambdaTransition(FiniteAutomaton.Node start, FiniteAutomaton.Node end) {
        FiniteAutomaton.Transition newTransition = this.delegate.addLambdaTransition(start, end);
        this.transitions.add(newTransition);
        return newTransition;
    }

    @Override
    public FiniteAutomaton.NodeSet getNodes() {
        FiniteAutomaton.NodeSet nodeSet = this.delegate.createNodeSet();
        nodeSet.addAll(this.nodes);
        return nodeSet;
    }

    @Override
    public Set getTransitions() {
        return this.transitions;
    }

    @Override
    public FiniteAutomaton.NodeSet createNodeSet() {
        return this.delegate.createNodeSet();
    }

    public NfaSubModel duplicate() {
        NfaSubModel newSubModel = new NfaSubModel(this.delegate);
        HashMap<FiniteAutomaton.Node, FiniteAutomaton.Node> old2New = new HashMap<FiniteAutomaton.Node, FiniteAutomaton.Node>();
        for (FiniteAutomaton.Node oldNode : this.nodes) {
            old2New.put(oldNode, newSubModel.addNode(oldNode.isTerminal()));
        }
        newSubModel.setStart((FiniteAutomaton.Node)old2New.get(this.start));
        newSubModel.setEnd((FiniteAutomaton.Node)old2New.get(this.end));
        for (FiniteAutomaton.Transition oldTrans : this.transitions) {
            newSubModel.addTransition((FiniteAutomaton.Node)old2New.get(oldTrans.source), (FiniteAutomaton.Node)old2New.get(oldTrans.dest), oldTrans.sym);
        }
        return newSubModel;
    }

    public void append(NfaSubModel submodel) {
        this.addEpsilonTransition(this.end, submodel.getStart());
        this.setEnd(submodel.getEnd());
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

