/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.SVMKernel;

public class SigmoidKernel
implements SVMKernel {
    private double a = 1.0;
    private double c = 1.0;
    private SVMKernel kernel = null;

    @Override
    public double evaluate(Object a, Object b) {
        return this.tanh(this.getMultiplier() * this.getWrappedKernel().evaluate(a, b) + this.getConstant());
    }

    public double getConstant() {
        return this.c;
    }

    public void setConstant(double c) {
        this.c = c;
    }

    public double getMultiplier() {
        return this.a;
    }

    public void setMultiplier(double m) {
        this.a = m;
    }

    public SVMKernel getWrappedKernel() {
        return this.kernel;
    }

    public void setWrappedKernel(SVMKernel kernel) {
        this.kernel = kernel;
    }

    public String toString() {
        return "Sigmoid kernel K(x, k) = tanh(" + this.getMultiplier() + ".k(x) + " + this.c + "). k = " + this.getWrappedKernel().toString();
    }

    public double tanh(double a) {
        double x = Math.exp(a);
        double y = Math.exp(-a);
        return (x - y) / (x + y);
    }
}

