/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.bio.Annotation;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;

public interface OntologyTerm
extends Term {
    @Override
    public Ontology getOntology();

    public static final class Impl
    extends AbstractChangeable
    implements OntologyTerm,
    Serializable {
        private final Ontology ontology;
        private final Ontology target;
        private transient ChangeForwarder forwarder;
        private Set synonyms;

        public Impl(Ontology ontology, Ontology target) {
            this(ontology, target, null);
        }

        public Impl(Ontology ontology, Ontology target, Object[] synonyms) {
            if (ontology == null) {
                throw new NullPointerException("The ontology may not be null");
            }
            if (target == null) {
                throw new NullPointerException("The targetted ontology may not be null");
            }
            this.ontology = ontology;
            this.target = target;
            this.synonyms = new TreeSet();
            if (synonyms != null) {
                this.synonyms.addAll(Arrays.asList(synonyms));
            }
        }

        @Override
        public void addSynonym(Object synonym) {
            this.synonyms.add(synonym);
        }

        @Override
        public void removeSynonym(Object synonym) {
            this.synonyms.remove(synonym);
        }

        @Override
        public Object[] getSynonyms() {
            return this.synonyms.toArray();
        }

        @Override
        public String getName() {
            return this.target.getName();
        }

        @Override
        public String getDescription() {
            return this.target.getDescription();
        }

        @Override
        public void setDescription(String description) {
            this.target.setDescription(description);
        }

        @Override
        public Ontology getOntology() {
            return this.ontology;
        }

        public Ontology getTargetOntology() {
            return this.target;
        }

        public String toString() {
            return "Remote ontology: " + this.getName();
        }

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        @Override
        public ChangeSupport getChangeSupport(ChangeType ct) {
            ChangeSupport cs = super.getChangeSupport(ct);
            this.forwarder = new ChangeForwarder(this, cs){

                @Override
                protected ChangeEvent generateEvent(ChangeEvent cev) {
                    return new ChangeEvent(this.getSource(), ChangeType.UNKNOWN, target, null, cev);
                }
            };
            this.target.addChangeListener(this.forwarder, ChangeType.UNKNOWN);
            return cs;
        }
    }
}

