/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.naming;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.biojava.naming.ObdaUriParser;

public class ObdaContext
implements DirContext {
    private ObdaContext parent;
    private String myAtomicName;
    private Hashtable bindings;
    private Hashtable env;
    private BasicAttributes attrs;

    protected Name getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return ObdaUriParser.getInstance().parse(name.get(0));
        }
        return name;
    }

    ObdaContext(ObdaContext parent, String myAtomicName, Hashtable bindings, Hashtable env, BasicAttributes attrs) {
        this.parent = parent;
        this.myAtomicName = myAtomicName;
        this.bindings = new Hashtable(bindings);
        this.env = new Hashtable(env);
        this.attrs = (BasicAttributes)attrs.clone();
    }

    Hashtable getBindings() {
        return this.bindings;
    }

    BasicAttributes getAttrs() {
        return this.attrs;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        ObdaContext ancestor = this.parent;
        if (ancestor == null) {
            return "";
        }
        Name name = ObdaUriParser.getInstance().parse("");
        name.add(this.myAtomicName);
        while (ancestor != null && ancestor.myAtomicName != null) {
            name.add(0, ancestor.myAtomicName);
            ancestor = ancestor.parent;
        }
        return name.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        if (!(name instanceof CompositeName) && !(prefix instanceof CompositeName)) {
            Name result = (Name)prefix.clone();
            result.addAll(name);
            return new CompositeName().add(result.toString());
        }
        throw new OperationNotSupportedException("Do not support composing composite names");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        System.err.println("lookup: '" + name + "' for " + this.bindings);
        if (name.isEmpty()) {
            System.err.println("Empty - return copy");
            return new ObdaContext(this.parent, this.myAtomicName, this.bindings, this.env, this.attrs);
        }
        Name nm = this.getMyComponents(name);
        System.err.println("My component is " + nm);
        String start = nm.get(0);
        Object answer = this.bindings.get(start);
        if (answer == null) {
            throw new NameNotFoundException(name + " not found");
        }
        if (nm.size() == 1) {
            return answer;
        }
        return ((Context)answer).lookup(nm.getSuffix(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfNames(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)target).list("");
                return namingEnumeration;
            }
            finally {
                ((Context)target).close();
            }
        }
        throw new NotContextException(name + " cannot be listed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfBindings(this.bindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)target).list("");
                return namingEnumeration;
            }
            finally {
                ((Context)target).close();
            }
        }
        throw new NotContextException(name + " cannot be listed");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return ObdaUriParser.getInstance();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable(this.env);
    }

    @Override
    public void close() throws NamingException {
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        if (name.isEmpty()) {
            return (Attributes)this.attrs.clone();
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.bindings.get(atom);
        if (nm.size() == 1) {
            if (inter == null) {
                throw new NameNotFoundException(name + " not found");
            }
            if (inter instanceof DirContext) {
                return ((DirContext)inter).getAttributes("", attrIds);
            }
            return (Attributes)this.attrs.clone();
        }
        if (!(inter instanceof DirContext)) {
            throw new NotContextException(atom + " does not name a dircontext");
        }
        return ((DirContext)inter).getAttributes(nm.getSuffix(1), attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes matchingAttrs) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(new CompositeName(name));
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(new CompositeName(name), attrIds);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(new CompositeName(name), mods);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(new CompositeName(name), (Object)attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(new CompositeName(name), obj, attrs);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(new CompositeName(name), attrs);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.getSchema(new CompositeName(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.getSchemaClassDefinition(new CompositeName(name));
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search((Name)new CompositeName(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(new CompositeName(name), matchingAttributes);
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search((Name)new CompositeName(name), filter, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(new CompositeName(name), filterExpr, filterArgs, cons);
    }

    class ListOfBindings
    implements NamingEnumeration {
        protected Enumeration names;

        ListOfBindings(Enumeration names) {
            this.names = names;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            Object bound = ObdaContext.this.bindings.get(name);
            return new Binding(name, bound);
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        @Override
        public void close() {
        }
    }

    class ListOfNames
    implements NamingEnumeration {
        protected Enumeration names;

        ListOfNames(Enumeration names) {
            this.names = names;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            String className = ObdaContext.this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        @Override
        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        @Override
        public void close() {
        }
    }
}

