/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.symbol.AbstractTranslationTable;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SimpleTranslationTable
extends AbstractTranslationTable
implements Serializable {
    private final Map transMap;
    private final FiniteAlphabet source;
    private final Alphabet target;

    @Override
    public Alphabet getSourceAlphabet() {
        return this.source;
    }

    @Override
    public Alphabet getTargetAlphabet() {
        return this.target;
    }

    @Override
    public Symbol doTranslate(Symbol sym) {
        return (Symbol)this.transMap.get(sym);
    }

    public void setTranslation(AtomicSymbol from, AtomicSymbol to) throws IllegalSymbolException {
        this.source.validate(from);
        this.target.validate(to);
        this.transMap.put(from, to);
    }

    public SimpleTranslationTable(FiniteAlphabet source, Alphabet target) {
        this.source = source;
        this.target = target;
        this.transMap = new HashMap();
    }

    public SimpleTranslationTable(FiniteAlphabet source, Alphabet target, Map transMap) {
        this.source = source;
        this.target = target;
        this.transMap = transMap;
    }
}

