/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.symbol.AbstractRangeLocation;
import org.biojava.bio.symbol.Location;

public class FuzzyLocation
extends AbstractRangeLocation
implements Serializable {
    public static final RangeResolver RESOLVE_INNER = new InnerRangeResolver();
    public static final RangeResolver RESOLVE_OUTER = new OuterRangeResolver();
    public static final RangeResolver RESOLVE_AVERAGE = new AverageRangeResolver();
    private int outerMin;
    private int innerMin;
    private int innerMax;
    private int outerMax;
    private boolean mIsMinFuzzy;
    private boolean mIsMaxFuzzy;
    private RangeResolver resolver;

    public FuzzyLocation(int outerMin, int outerMax, int innerMin, int innerMax, RangeResolver resolver) {
        boolean isMinFuzzy = false;
        boolean isMaxFuzzy = false;
        if (outerMin != innerMin) {
            isMinFuzzy = true;
        }
        if (outerMax != innerMax) {
            isMaxFuzzy = true;
        }
        this.initializeVariables(outerMin, outerMax, innerMin, innerMax, isMinFuzzy, isMaxFuzzy, resolver);
    }

    public FuzzyLocation(int outerMin, int outerMax, int innerMin, int innerMax, boolean isMinFuzzy, boolean isMaxFuzzy, RangeResolver resolver) {
        this.initializeVariables(outerMin, outerMax, innerMin, innerMax, isMinFuzzy, isMaxFuzzy, resolver);
    }

    @Override
    public Location translate(int dist) {
        return new FuzzyLocation(this.outerMin + dist, this.outerMax + dist, this.innerMin + dist, this.innerMax + dist, this.resolver);
    }

    public RangeResolver getResolver() {
        return this.resolver;
    }

    public int getOuterMin() {
        return this.outerMin;
    }

    public int getOuterMax() {
        return this.outerMax;
    }

    public int getInnerMin() {
        return this.innerMin;
    }

    public int getInnerMax() {
        return this.innerMax;
    }

    @Override
    public int getMin() {
        return this.resolver.resolveMin(this);
    }

    @Override
    public int getMax() {
        return this.resolver.resolveMax(this);
    }

    public boolean hasBoundedMin() {
        return this.outerMin != Integer.MIN_VALUE;
    }

    public boolean hasBoundedMax() {
        return this.outerMax != Integer.MAX_VALUE;
    }

    public String toString() {
        return "[" + (this.hasBoundedMin() ? Integer.toString(this.getMin()) : "<" + Integer.toString(this.getMin())) + ", " + (this.hasBoundedMax() ? Integer.toString(this.getMax()) : ">" + Integer.toString(this.getMax())) + "]";
    }

    public boolean isMinFuzzy() {
        return this.mIsMinFuzzy;
    }

    public boolean isMaxFuzzy() {
        return this.mIsMaxFuzzy;
    }

    protected void initializeVariables(int outerMin, int outerMax, int innerMin, int innerMax, boolean isMinFuzzy, boolean isMaxFuzzy, RangeResolver resolver) {
        this.outerMin = outerMin;
        this.outerMax = outerMax;
        this.innerMin = innerMin;
        this.innerMax = innerMax;
        this.resolver = resolver;
        this.mIsMinFuzzy = isMinFuzzy;
        this.mIsMaxFuzzy = isMaxFuzzy;
    }

    private static class AverageRangeResolver
    implements RangeResolver {
        private AverageRangeResolver() {
        }

        @Override
        public int resolveMin(FuzzyLocation loc) {
            if (loc.hasBoundedMin()) {
                return (loc.getOuterMin() + loc.getInnerMin()) / 2;
            }
            return loc.getInnerMin();
        }

        @Override
        public int resolveMax(FuzzyLocation loc) {
            if (loc.hasBoundedMax()) {
                return (loc.getOuterMax() + loc.getInnerMax()) / 2;
            }
            return loc.getInnerMax();
        }
    }

    private static class OuterRangeResolver
    implements RangeResolver {
        private OuterRangeResolver() {
        }

        @Override
        public int resolveMin(FuzzyLocation loc) {
            if (loc.hasBoundedMin()) {
                return loc.getOuterMin();
            }
            return loc.getInnerMin();
        }

        @Override
        public int resolveMax(FuzzyLocation loc) {
            if (loc.hasBoundedMax()) {
                return loc.getOuterMax();
            }
            return loc.getInnerMax();
        }
    }

    private static class InnerRangeResolver
    implements RangeResolver {
        private InnerRangeResolver() {
        }

        @Override
        public int resolveMin(FuzzyLocation loc) {
            return loc.getInnerMin();
        }

        @Override
        public int resolveMax(FuzzyLocation loc) {
            return loc.getInnerMax();
        }
    }

    public static interface RangeResolver
    extends Serializable {
        public int resolveMin(FuzzyLocation var1);

        public int resolveMax(FuzzyLocation var1);
    }
}

