/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.AssertionFailure;
import org.biojava.utils.SmallSet;

public class DNAAmbPack
implements Packing,
Serializable {
    private final Symbol[] syms = new Symbol[16];

    public DNAAmbPack() {
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            this.syms[i] = this._unpack(i);
        }
    }

    @Override
    public FiniteAlphabet getAlphabet() {
        return DNATools.getDNA();
    }

    @Override
    public byte pack(Symbol sym) {
        if (sym == DNATools.a()) {
            return 1;
        }
        if (sym == DNATools.g()) {
            return 2;
        }
        if (sym == DNATools.c()) {
            return 4;
        }
        if (sym == DNATools.t()) {
            return 8;
        }
        if (sym == DNATools.n()) {
            return 15;
        }
        byte p = 0;
        Iterator<Symbol> i = ((FiniteAlphabet)sym.getMatches()).iterator();
        while (i.hasNext()) {
            p = (byte)(p | this.pack((AtomicSymbol)i.next()));
        }
        return p;
    }

    @Override
    public Symbol unpack(byte b) {
        return this.syms[b];
    }

    private Symbol _unpack(byte b) {
        SmallSet syms = new SmallSet();
        if (0 != (b & 1)) {
            syms.add(DNATools.a());
        }
        if (0 != (b & 2)) {
            syms.add(DNATools.g());
        }
        if (0 != (b & 4)) {
            syms.add(DNATools.c());
        }
        if (0 != (b & 8)) {
            syms.add(DNATools.t());
        }
        try {
            if (b != 0) {
                return DNATools.getDNA().getAmbiguity(syms);
            }
            return DNATools.getDNA().getGapSymbol();
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure("Assertion failure: couldn't get DNA ambiguity from DNA: " + syms, ise);
        }
    }

    @Override
    public byte wordSize() {
        return 4;
    }

    @Override
    public boolean handlesAmbiguity() {
        return true;
    }
}

