/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.io.AlternateTokenization;
import org.biojava.bio.seq.io.CharacterTokenization;
import org.biojava.bio.seq.io.NameTokenization;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AbstractSimpleBasisSymbol;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.CrossProductAlphabetIndex;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.HashedAlphabetIndex;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.InfiniteCrossProductAlphabet;
import org.biojava.bio.symbol.IntegerAlphabet;
import org.biojava.bio.symbol.LinearAlphabetIndex;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleAtomicSymbol;
import org.biojava.bio.symbol.SimpleBasisSymbol;
import org.biojava.bio.symbol.SimpleCrossProductAlphabet;
import org.biojava.bio.symbol.SimpleSymbol;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.SparseCrossProductAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.ClassTools;
import org.biojava.utils.Unchangeable;
import org.biojava.utils.cache.WeakValueHashMap;
import org.biojava.utils.lsid.Identifiable;
import org.biojava.utils.lsid.LifeScienceIdentifier;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class AlphabetManager {
    private static Map nameToAlphabet;
    private static Map lsidToSymbol;
    private static Map crossProductAlphabets;
    private static Map ambiguitySymbols;
    private static GapSymbol gapSymbol;
    private static Map gapBySize;
    private static Map alphabetToIndex;
    private static Map symListToSymbol;
    private static AlphabetManager am;

    public static AlphabetManager instance() {
        if (am == null) {
            am = new AlphabetManager();
        }
        return am;
    }

    public static Symbol getAllAmbiguitySymbol(FiniteAlphabet alpha) {
        HashSet<Symbol> allSymbols = new HashSet<Symbol>();
        Iterator<Symbol> i = alpha.iterator();
        while (i.hasNext()) {
            allSymbols.add(i.next());
        }
        try {
            return alpha.getAmbiguity(allSymbols);
        }
        catch (IllegalSymbolException ex) {
            throw new BioError("Assertion failure: coudn't recover all-ambiguity symbol", ex);
        }
    }

    public static Set getAllSymbols(FiniteAlphabet alpha) {
        HashSet<Symbol> allSymbols = new HashSet<Symbol>();
        ArrayList<Symbol> orderedAlpha = new ArrayList<Symbol>(alpha.size());
        Iterator<Symbol> i = alpha.iterator();
        while (i.hasNext()) {
            orderedAlpha.add(i.next());
        }
        int atomicSyms = alpha.size();
        int totalSyms = 1 << atomicSyms;
        for (int cnt = 0; cnt < totalSyms; ++cnt) {
            HashSet<Symbol> matchSet = new HashSet<Symbol>();
            for (int atom = 0; atom < atomicSyms; ++atom) {
                if ((cnt & 1 << atom) == 0) continue;
                matchSet.add((Symbol)orderedAlpha.get(atom));
            }
            try {
                allSymbols.add(alpha.getAmbiguity(matchSet));
                continue;
            }
            catch (IllegalSymbolException ex) {
                throw new BioError("Assertion failed: couldn't get ambiguity symbol", ex);
            }
        }
        return allSymbols;
    }

    public static Alphabet alphabetForName(String name) throws NoSuchElementException {
        Alphabet alpha = (Alphabet)nameToAlphabet.get(name);
        if (alpha == null) {
            if (name.startsWith("(") && name.endsWith(")")) {
                alpha = AlphabetManager.generateCrossProductAlphaFromName(name);
            } else {
                throw new NoSuchElementException("No alphabet for name " + name + " could be found");
            }
        }
        return alpha;
    }

    public static Symbol symbolForName(String name) throws NoSuchElementException {
        String ls = "urn:lsid:biojava.org:symbol:" + name;
        LifeScienceIdentifier lsid = null;
        try {
            lsid = LifeScienceIdentifier.valueOf(ls);
        }
        catch (LifeScienceIdentifierParseException ex) {
            throw new BioError("Cannot construct LSID for " + name, ex);
        }
        Symbol s = (Symbol)lsidToSymbol.get(lsid);
        if (s == null) {
            throw new NoSuchElementException("Could not find symbol under the name " + lsid);
        }
        return s;
    }

    public static Symbol symbolForLifeScienceID(LifeScienceIdentifier lsid) {
        return (Symbol)lsidToSymbol.get(lsid);
    }

    public static void registerAlphabet(String name, Alphabet alphabet) {
        nameToAlphabet.put(name, alphabet);
        if (alphabet instanceof AbstractAlphabet) {
            ((AbstractAlphabet)alphabet).setRegistered(true);
        }
    }

    public static void registerAlphabet(String[] names, Alphabet alphabet) {
        for (int i = 0; i < names.length; ++i) {
            AlphabetManager.registerAlphabet(names[i], alphabet);
        }
    }

    public static Set registrations() {
        return Collections.unmodifiableSet(nameToAlphabet.keySet());
    }

    public static boolean registered(String name) {
        return nameToAlphabet.containsKey(name);
    }

    public static Iterator alphabets() {
        return Collections.unmodifiableCollection(nameToAlphabet.values()).iterator();
    }

    public static Symbol getGapSymbol() {
        return gapSymbol;
    }

    public static Symbol getGapSymbol(List alphas) {
        SizeQueen sq = new SizeQueen(alphas);
        Symbol s = (Symbol)gapBySize.get(sq);
        if (s == null) {
            if (alphas.size() == 0) {
                s = gapSymbol;
            } else if (alphas.size() == 1) {
                Alphabet a = (Alphabet)alphas.get(0);
                s = AlphabetManager.getGapSymbol(a.getAlphabets());
            } else {
                ArrayList<Symbol> symList = new ArrayList<Symbol>(alphas.size());
                for (Alphabet a : alphas) {
                    symList.add(AlphabetManager.getGapSymbol(a.getAlphabets()));
                }
                try {
                    s = new WellKnownGapSymbol(symList, sq);
                }
                catch (IllegalSymbolException ise) {
                    throw new BioError("Assertion Failure: Should be able to make gap basis", ise);
                }
            }
            gapBySize.put(sq, s);
        }
        return s;
    }

    public static AtomicSymbol createSymbol(String name, Annotation annotation) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, annotation);
        return as;
    }

    public static AtomicSymbol createSymbol(String name) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, Annotation.EMPTY_ANNOTATION);
        return as;
    }

    public static AtomicSymbol createSymbol(char token, String name, Annotation annotation) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, annotation);
        return as;
    }

    public static Symbol createSymbol(char token, Annotation annotation, List symList, Alphabet alpha) throws IllegalSymbolException {
        return AlphabetManager.createSymbol(annotation, symList, alpha);
    }

    private static Symbol readFromCache(List symList) {
        return (Symbol)symListToSymbol.get(symList);
    }

    private static void writeToCache(List symList, Symbol sym) {
        symListToSymbol.put(new ArrayList(symList), sym);
    }

    public static Symbol createSymbol(Annotation annotation, List symList, Alphabet alpha) throws IllegalSymbolException {
        Symbol cs = AlphabetManager.readFromCache(symList);
        if (cs != null) {
            return cs;
        }
        Iterator i = symList.iterator();
        int basis = 0;
        int atomC = 0;
        int gaps = 0;
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (s instanceof BasisSymbol) {
                ++basis;
                if (!(s instanceof AtomicSymbol)) continue;
                ++atomC;
                continue;
            }
            Alphabet matches = s.getMatches();
            if (!(matches instanceof FiniteAlphabet) || ((FiniteAlphabet)matches).size() != 0) continue;
            ++gaps;
        }
        try {
            SimpleSymbol sym;
            if (atomC == symList.size()) {
                sym = new SimpleAtomicSymbol(annotation, symList);
                AlphabetManager.writeToCache(symList, sym);
                return sym;
            }
            if (gaps + basis == symList.size()) {
                sym = new SimpleBasisSymbol(annotation, symList, new SimpleAlphabet(AlphabetManager.expandMatches(alpha, symList, new ArrayList())));
                AlphabetManager.writeToCache(symList, sym);
                return sym;
            }
            sym = new SimpleSymbol(annotation, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, symList, new ArrayList())));
            AlphabetManager.writeToCache(symList, sym);
            return sym;
        }
        catch (IllegalSymbolException ise) {
            throw new IllegalSymbolException(ise, "Could not create a new symbol with: " + annotation + "\t" + symList + "\t" + alpha);
        }
    }

    private static Set expandBasis(Alphabet alpha, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            Symbol s = (Symbol)symList.get(indx);
            if (s instanceof AtomicSymbol) {
                built.add(s);
                return AlphabetManager.expandBasis(alpha, symList, built);
            }
            HashSet res = new HashSet();
            Iterator<Symbol> i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)i.next();
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add(as);
                res.addAll(AlphabetManager.expandBasis(alpha, symList, built2));
            }
            return res;
        }
        try {
            return Collections.singleton(alpha.getSymbol(built));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Should just have legal AtomicSymbol instances.", ise);
        }
    }

    public static Symbol createSymbol(char token, Annotation annotation, Set symSet, Alphabet alpha) throws IllegalSymbolException {
        return AlphabetManager.createSymbol(annotation, symSet, alpha);
    }

    public static Symbol createSymbol(Annotation annotation, Set symSet, Alphabet alpha) throws IllegalSymbolException {
        if (symSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        HashSet<AtomicSymbol> asSet = new HashSet<AtomicSymbol>();
        int len = -1;
        for (Symbol s : symSet) {
            if (s instanceof AtomicSymbol) {
                AtomicSymbol as = (AtomicSymbol)s;
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
                continue;
            }
            Iterator<Symbol> j = ((FiniteAlphabet)s.getMatches()).iterator();
            while (j.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)j.next();
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
            }
        }
        if (asSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        if (asSet.size() == 1) {
            return (Symbol)asSet.iterator().next();
        }
        if (len == 1) {
            return new SimpleBasisSymbol(annotation, new SimpleAlphabet(asSet));
        }
        List fs = AlphabetManager.factorize(alpha, asSet);
        if (fs == null) {
            return new SimpleSymbol(annotation, new SimpleAlphabet(asSet));
        }
        return new SimpleBasisSymbol(annotation, fs, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, fs, new ArrayList())));
    }

    public static Alphabet generateCrossProductAlphaFromName(String name) {
        if (!name.startsWith("(") || !name.endsWith(")")) {
            throw new BioError("Can't parse " + name + " into a cross-product alphabet as it is not bracketed");
        }
        name = name.substring(1, name.length() - 1).trim();
        ArrayList<Alphabet> aList = new ArrayList<Alphabet>();
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '(') {
                int j;
                int depth = 1;
                for (j = i + 1; j < name.length() && depth > 0; ++j) {
                    char c = name.charAt(j);
                    if (c == '(') {
                        ++depth;
                        continue;
                    }
                    if (c != ')') continue;
                    --depth;
                }
                if (depth == 0) {
                    aList.add(AlphabetManager.alphabetForName(name.substring(i, j)));
                    i = j;
                    continue;
                }
                throw new BioError("Error parsing alphabet name: could not find matching bracket\n" + name.substring(i));
            }
            int j = name.indexOf(" x ", i);
            if (j < 0) {
                aList.add(AlphabetManager.alphabetForName(name.substring(i).trim()));
                i = name.length();
                continue;
            }
            if (i != j) {
                aList.add(AlphabetManager.alphabetForName(name.substring(i, j).trim()));
            }
            i = j + " x ".length();
        }
        return AlphabetManager.getCrossProductAlphabet(aList);
    }

    public static Alphabet getCrossProductAlphabet(List aList) {
        return AlphabetManager.getCrossProductAlphabet(aList, (Alphabet)null);
    }

    public static Alphabet getCrossProductAlphabet(List aList, String name) throws IllegalAlphabetException {
        Alphabet currentAlpha = (Alphabet)nameToAlphabet.get(name);
        if (currentAlpha != null) {
            if (currentAlpha.getAlphabets().equals(aList)) {
                return currentAlpha;
            }
            throw new IllegalAlphabetException(name + " already registered");
        }
        Alphabet alpha = AlphabetManager.getCrossProductAlphabet(aList);
        AlphabetManager.registerAlphabet(name, alpha);
        return alpha;
    }

    public static Alphabet getCrossProductAlphabet(List aList, Alphabet parent) {
        if (aList.size() == 0) {
            return Alphabet.EMPTY_ALPHABET;
        }
        if (aList.size() == 1) {
            return (Alphabet)aList.get(0);
        }
        if (crossProductAlphabets == null) {
            crossProductAlphabets = new HashMap();
        }
        Alphabet cpa = (Alphabet)crossProductAlphabets.get(aList);
        int size = 1;
        if (cpa == null) {
            for (Alphabet aa : aList) {
                if (!(aa instanceof FiniteAlphabet)) {
                    cpa = new InfiniteCrossProductAlphabet(aList);
                    break;
                }
                if (size > 1000) continue;
                size *= ((FiniteAlphabet)aa).size();
            }
            if (cpa == null) {
                try {
                    cpa = size > 0 && size < 1000 ? new SimpleCrossProductAlphabet(aList, parent) : new SparseCrossProductAlphabet(aList);
                }
                catch (IllegalAlphabetException iae) {
                    throw new BioError("Could not create SimpleCrossProductAlphabet for " + aList + " even though we should be able to. No idea what is wrong.");
                }
            }
            crossProductAlphabets.put(new ArrayList(aList), cpa);
            AlphabetManager.registerAlphabet(cpa.getName(), cpa);
        }
        return cpa;
    }

    private static Set expandMatches(Alphabet parent, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            Symbol bs = (Symbol)symList.get(indx);
            if (bs instanceof AtomicSymbol) {
                built.add(bs);
                return AlphabetManager.expandMatches(parent, symList, built);
            }
            HashSet syms = new HashSet();
            Iterator<Symbol> i = ((FiniteAlphabet)bs.getMatches()).iterator();
            while (i.hasNext()) {
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add((AtomicSymbol)i.next());
                syms.addAll(AlphabetManager.expandMatches(parent, symList, built2));
            }
            return syms;
        }
        try {
            Symbol s = parent.getSymbol(built);
            if (s instanceof AtomicSymbol) {
                return Collections.singleton((AtomicSymbol)s);
            }
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            Iterator<Symbol> i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)i.next());
            }
            return syms;
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Couldn't create symbol.", ise);
        }
    }

    public static List factorize(Alphabet alpha, Set symSet) throws IllegalSymbolException {
        List<Alphabet> alphas = alpha.getAlphabets();
        ArrayList<Symbol> facts = new ArrayList<Symbol>();
        int size = symSet.size();
        HashSet<Symbol> syms = new HashSet<Symbol>();
        for (int col = 0; col < alphas.size(); ++col) {
            Alphabet a = alphas.get(col);
            Iterator i = symSet.iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)((AtomicSymbol)i.next()).getSymbols().get(col));
            }
            int s = syms.size();
            if (size % s != 0) {
                return null;
            }
            size /= s;
            facts.add(a.getAmbiguity(syms));
            syms.clear();
        }
        if (size != 1) {
            return null;
        }
        return facts;
    }

    public static void loadAlphabets(InputSource is) throws SAXException, IOException, BioException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader parser = spf.newSAXParser().getXMLReader();
            parser.setContentHandler(new SAX2StAXAdaptor(new AlphabetManagerHandler()));
            parser.parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new BioException("Unable to create XML parser", ex);
        }
    }

    public static AlphabetIndex getAlphabetIndex(FiniteAlphabet alpha) {
        int generateIndexSize = 160;
        Changeable ai = (AlphabetIndex)alphabetToIndex.get(alpha);
        if (ai == null) {
            int size = alpha.size();
            ai = size <= 160 ? new LinearAlphabetIndex(alpha) : (alpha.getAlphabets().size() > 1 ? new CrossProductAlphabetIndex(alpha) : new HashedAlphabetIndex(alpha));
            alphabetToIndex.put(alpha, ai);
        }
        return ai;
    }

    public static AlphabetIndex getAlphabetIndex(Symbol[] syms) throws IllegalSymbolException, BioException {
        return new LinearAlphabetIndex(syms);
    }

    private static Symbol getWellKnownAmbiguitySymbol(Set s) {
        Symbol sym = (Symbol)ambiguitySymbols.get(s);
        if (sym == null) {
            WellKnownAlphabet matchAlpha = new WellKnownAlphabet(s);
            sym = new WellKnownBasisSymbol(new SimpleBasisSymbol(Annotation.EMPTY_ANNOTATION, matchAlpha));
            ambiguitySymbols.put(new HashSet(s), sym);
        }
        return sym;
    }

    static {
        alphabetToIndex = new WeakHashMap();
        nameToAlphabet = new HashMap();
        lsidToSymbol = new HashMap();
        ambiguitySymbols = new HashMap();
        gapSymbol = new GapSymbol();
        gapBySize = new HashMap();
        gapBySize.put(new SizeQueen(new ArrayList()), gapSymbol);
        nameToAlphabet.put("INTEGER", IntegerAlphabet.getInstance());
        nameToAlphabet.put("DOUBLE", DoubleAlphabet.getInstance());
        symListToSymbol = new WeakValueHashMap();
        try {
            SizeQueen sq = new SizeQueen(Arrays.asList(DoubleAlphabet.getInstance()));
            gapBySize.put(sq, new WellKnownGapSymbol(Arrays.asList(gapSymbol), sq));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError("Assertion Failure: Should be able to make gap basis", ise);
        }
        ambiguitySymbols.put(new HashSet(), gapSymbol);
        try {
            InputStream alphabetStream = ClassTools.getClassLoader(AlphabetManager.class).getResourceAsStream("org/biojava/bio/symbol/AlphabetManager.xml");
            if (alphabetStream == null) {
                throw new BioError("Couldn't locate AlphabetManager.xml.  This probably means that your biojava.jar file is corrupt or incorrectly built.");
            }
            InputSource is = new InputSource(alphabetStream);
            AlphabetManager.loadAlphabets(is);
        }
        catch (Exception t) {
            throw new BioError("Unable to initialize AlphabetManager", t);
        }
    }

    private static final class SizeQueen
    extends AbstractList
    implements Serializable {
        private final List alphas;

        public SizeQueen(List alphas) {
            this.alphas = alphas;
        }

        @Override
        public int size() {
            return this.alphas.size();
        }

        public List getAlphas() {
            return this.alphas;
        }

        @Override
        public Object get(int pos) {
            Alphabet a = (Alphabet)this.alphas.get(pos);
            List<Alphabet> al = a.getAlphabets();
            int size = al.size();
            if (size > 1) {
                return new SizeQueen(al);
            }
            return new Integer(size);
        }
    }

    private static class GapSymbol
    extends Unchangeable
    implements Symbol,
    Serializable {
        @Override
        public String getName() {
            return "gap";
        }

        public char getToken() {
            return '-';
        }

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        @Override
        public Alphabet getMatches() {
            return Alphabet.EMPTY_ALPHABET;
        }

        private Object readResolve() throws ObjectStreamException {
            return AlphabetManager.getGapSymbol();
        }
    }

    private static class WellKnownBasisSymbol
    extends Unchangeable
    implements BasisSymbol,
    Serializable {
        protected BasisSymbol symbol;
        private Set matches;

        WellKnownBasisSymbol(BasisSymbol symbol) {
            symbol.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
            this.symbol = symbol;
            this.matches = new HashSet();
            Iterator<Symbol> i = ((FiniteAlphabet)symbol.getMatches()).iterator();
            while (i.hasNext()) {
                this.matches.add(i.next());
            }
        }

        Symbol getSymbol() {
            return this.symbol;
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof WellKnownBasisSymbol) {
                return this.symbol.equals(((WellKnownBasisSymbol)o).getSymbol());
            }
            return false;
        }

        @Override
        public String getName() {
            return this.symbol.getName();
        }

        @Override
        public Alphabet getMatches() {
            return this.symbol.getMatches();
        }

        @Override
        public List getSymbols() {
            return Collections.singletonList(this);
        }

        @Override
        public Annotation getAnnotation() {
            return this.symbol.getAnnotation();
        }

        private Object writeReplace() {
            return new OPH(this.matches);
        }

        private static class OPH
        implements Serializable {
            private Set matches;

            public OPH(Set matches) {
                this.matches = matches;
            }

            private Object readResolve() {
                return AlphabetManager.getWellKnownAmbiguitySymbol(this.matches);
            }
        }
    }

    private static class WellKnownAtomicSymbol
    extends WellKnownBasisSymbol
    implements AtomicSymbol,
    Identifiable {
        LifeScienceIdentifier lsid;

        WellKnownAtomicSymbol(AtomicSymbol symbol, LifeScienceIdentifier lsid) {
            super(symbol);
            this.lsid = lsid;
        }

        @Override
        public LifeScienceIdentifier getIdentifier() {
            return this.lsid;
        }

        @Override
        public Alphabet getMatches() {
            return new SingletonAlphabet(this);
        }

        private Object writeReplace() {
            return new OPH(this.getIdentifier());
        }

        private static class OPH
        implements Serializable {
            private LifeScienceIdentifier name;

            public OPH(LifeScienceIdentifier name) {
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    return AlphabetManager.symbolForLifeScienceID(this.name);
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve symbol:" + this.name);
                }
            }
        }
    }

    private static class WellKnownGapSymbol
    extends AbstractSimpleBasisSymbol
    implements Serializable {
        private SizeQueen sq;

        public WellKnownGapSymbol(List symList, SizeQueen sq) throws IllegalSymbolException {
            super(Annotation.EMPTY_ANNOTATION, symList, Alphabet.EMPTY_ALPHABET);
            this.sq = sq;
        }

        private Object readResolve() throws ObjectStreamException {
            return AlphabetManager.getGapSymbol(this.sq.getAlphas());
        }
    }

    private static class ImmutableWellKnownAlphabetWrapper
    extends Unchangeable
    implements FiniteAlphabet,
    Serializable {
        private FiniteAlphabet alpha;
        private Map tokenizationsByName = new HashMap();

        public ImmutableWellKnownAlphabetWrapper(FiniteAlphabet alpha) {
            this.alpha = alpha;
        }

        private Object writeReplace() {
            return new OPH(this.getName());
        }

        @Override
        public SymbolTokenization getTokenization(String name) throws BioException {
            SymbolTokenization toke = (SymbolTokenization)this.tokenizationsByName.get(name);
            if (toke == null) {
                toke = "name".equals(name) ? new NameTokenization(this) : new WellKnownTokenizationWrapper(this, this.alpha.getTokenization(name), name);
                this.tokenizationsByName.put(name, toke);
            }
            return toke;
        }

        @Override
        public boolean contains(Symbol s) {
            return this.alpha.contains(s);
        }

        public List getAlphabets() {
            return Collections.singletonList(this);
        }

        public Symbol getAmbiguity(Set s) throws IllegalSymbolException {
            return this.alpha.getAmbiguity(s);
        }

        @Override
        public Symbol getGapSymbol() {
            return this.alpha.getGapSymbol();
        }

        @Override
        public String getName() {
            return this.alpha.getName();
        }

        public Symbol getSymbol(List l) throws IllegalSymbolException {
            return this.alpha.getSymbol(l);
        }

        @Override
        public void validate(Symbol s) throws IllegalSymbolException {
            this.alpha.validate(s);
        }

        @Override
        public void addSymbol(Symbol s) throws ChangeVetoException {
            throw new ChangeVetoException("Can't add symbols to Well Known Alphabets");
        }

        @Override
        public void removeSymbol(Symbol s) throws ChangeVetoException {
            throw new ChangeVetoException("Can't remove symbols from Well Known Alphabets");
        }

        public Iterator iterator() {
            return this.alpha.iterator();
        }

        @Override
        public int size() {
            return this.alpha.size();
        }

        @Override
        public Annotation getAnnotation() {
            return this.alpha.getAnnotation();
        }

        private static class OPH
        implements Serializable {
            private String name;

            public OPH(String name) {
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    Alphabet a = AlphabetManager.alphabetForName(this.name);
                    return a;
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve alphabet " + this.name);
                }
            }
        }
    }

    private static class WellKnownAlphabet
    extends SimpleAlphabet {
        public WellKnownAlphabet() {
        }

        public WellKnownAlphabet(Set s) {
            super(s);
        }

        @Override
        protected Symbol getAmbiguityImpl(Set s) throws IllegalSymbolException {
            return AlphabetManager.getWellKnownAmbiguitySymbol(s);
        }
    }

    private static class WellKnownTokenizationWrapper
    extends Unchangeable
    implements SymbolTokenization,
    Serializable {
        private String name;
        private Alphabet alphabet;
        private SymbolTokenization toke;

        WellKnownTokenizationWrapper(Alphabet alpha, SymbolTokenization toke, String name) {
            this.alphabet = alpha;
            this.name = name;
            this.toke = toke;
        }

        @Override
        public Alphabet getAlphabet() {
            return this.alphabet;
        }

        @Override
        public SymbolTokenization.TokenType getTokenType() {
            return this.toke.getTokenType();
        }

        @Override
        public StreamParser parseStream(SeqIOListener listener) {
            return this.toke.parseStream(listener);
        }

        @Override
        public Symbol parseToken(String s) throws IllegalSymbolException {
            return this.toke.parseToken(s);
        }

        @Override
        public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
            return this.toke.tokenizeSymbol(s);
        }

        @Override
        public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException, IllegalSymbolException {
            return this.toke.tokenizeSymbolList(sl);
        }

        @Override
        public Annotation getAnnotation() {
            return this.toke.getAnnotation();
        }

        public Object writeReplace() {
            return new OPH(this.getAlphabet().getName(), this.name);
        }

        private static class OPH
        implements Serializable {
            private String alphaName;
            private String name;

            OPH(String alphaName, String name) {
                this.alphaName = alphaName;
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    Alphabet alphabet = AlphabetManager.alphabetForName(this.alphaName);
                    return alphabet.getTokenization(this.name);
                }
                catch (Exception ex) {
                    throw new InvalidObjectException("Couldn't resolve tokenization " + this.name + " in alphabet " + this.alphaName);
                }
            }
        }
    }

    private static class AlphabetManagerHandler
    extends StAXContentHandlerBase {
        private AlphabetManagerHandler() {
        }

        @Override
        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (!localName.equals("alphabetManager")) {
                if (localName.equals("symbol")) {
                    String name = attrs.getValue("name");
                    dm.delegate(new SymbolHandler(name));
                } else if (localName.equals("alphabet")) {
                    String name = attrs.getValue("name");
                    String parent = attrs.getValue("parent");
                    FiniteAlphabet parentAlpha = null;
                    if (parent != null && parent.length() > 0) {
                        parentAlpha = (FiniteAlphabet)nameToAlphabet.get(parent);
                    }
                    dm.delegate(new AlphabetHandler(name, parentAlpha));
                } else {
                    throw new SAXException("Unknown element in alphabetManager: " + localName);
                }
            }
        }

        @Override
        public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
            if (delegate instanceof SymbolHandler) {
                SymbolHandler sh = (SymbolHandler)delegate;
                LifeScienceIdentifier lsid = sh.getLSID();
                Symbol symbol = sh.getSymbol();
                if (lsidToSymbol.containsKey(lsid)) {
                    throw new SAXException("There is already a top-level symbol named " + lsid);
                }
                lsidToSymbol.put(lsid, symbol);
            } else if (delegate instanceof AlphabetHandler) {
                AlphabetHandler ah = (AlphabetHandler)delegate;
                String name = ah.getName();
                FiniteAlphabet alpha = ah.getAlphabet();
                AlphabetManager.registerAlphabet(name, (Alphabet)alpha);
            }
        }

        private class CharacterTokenizationHandler
        extends StAXContentHandlerBase {
            private String name;
            private Map localSymbols;
            private SymbolTokenization toke;
            private boolean isAlternate;

            String getName() {
                return this.name;
            }

            SymbolTokenization getTokenization() {
                return this.toke;
            }

            public CharacterTokenizationHandler(String name, FiniteAlphabet alpha, Map localSymbols, boolean caseSensitive) {
                this.name = name;
                this.localSymbols = new HashMap();
                Iterator<Symbol> i = alpha.iterator();
                while (i.hasNext()) {
                    WellKnownAtomicSymbol sym = (WellKnownAtomicSymbol)i.next();
                    this.localSymbols.put(sym.getIdentifier(), sym);
                }
                if (name.indexOf("alternate") == 0) {
                    this.toke = new AlternateTokenization(alpha, caseSensitive);
                    this.isAlternate = true;
                } else {
                    this.toke = new CharacterTokenization(alpha, caseSensitive);
                }
            }

            @Override
            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("characterTokenization")) {
                    if (localName.equals("atomicMapping")) {
                        dm.delegate(new MappingHandler(true));
                    } else if (localName.equals("ambiguityMapping")) {
                        dm.delegate(new MappingHandler(false));
                    } else if (localName.equals("gapSymbolMapping")) {
                        dm.delegate(new MappingHandler(false, true));
                    } else {
                        throw new SAXException("Unknown element in characterTokenization: " + localName);
                    }
                }
            }

            private class MappingHandler
            extends StAXContentHandlerBase {
                boolean isAtomic;
                boolean isPureGap;
                Set symbols = new HashSet();
                char c = '\u0000';
                String str = "";
                int level = 0;

                public MappingHandler(boolean isAtomic, boolean isPureGap) {
                    this.isAtomic = isAtomic;
                    this.isPureGap = isPureGap;
                }

                public MappingHandler(boolean isAtomic) {
                    this(isAtomic, false);
                }

                @Override
                public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                    if (this.level == 0) {
                        this.c = attrs.getValue("token").charAt(0);
                        if (CharacterTokenizationHandler.this.isAlternate) {
                            this.str = attrs.getValue("token");
                        }
                    } else if (localName.equals("symbolref")) {
                        String name = attrs.getValue("name");
                        LifeScienceIdentifier lsid = null;
                        try {
                            lsid = LifeScienceIdentifier.valueOf(name);
                        }
                        catch (LifeScienceIdentifierParseException ex) {
                            throw new SAXException("Cannot for LSID from " + name);
                        }
                        Symbol sym = (Symbol)CharacterTokenizationHandler.this.localSymbols.get(lsid);
                        if (sym == null) {
                            throw new SAXException("Reference to non-existent symbol " + name);
                        }
                        this.symbols.add(sym);
                    } else {
                        throw new SAXException("Unknown element in mapping: " + localName);
                    }
                    ++this.level;
                }

                @Override
                public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                    --this.level;
                }

                @Override
                public void endTree() throws SAXException {
                    Symbol ambiSym;
                    if (this.isPureGap) {
                        ambiSym = AlphabetManager.getGapSymbol();
                    } else {
                        try {
                            ambiSym = CharacterTokenizationHandler.this.toke.getAlphabet().getAmbiguity(this.symbols);
                        }
                        catch (IllegalSymbolException ex) {
                            throw (SAXException)new SAXException("IllegalSymbolException binding mapping for " + this.c).initCause(ex);
                        }
                    }
                    if (CharacterTokenizationHandler.this.isAlternate) {
                        ((AlternateTokenization)CharacterTokenizationHandler.this.toke).bindSymbol(ambiSym, this.str);
                    } else {
                        ((CharacterTokenization)CharacterTokenizationHandler.this.toke).bindSymbol(ambiSym, this.c);
                    }
                }
            }
        }

        private class AlphabetHandler
        extends StAXContentHandlerBase {
            private String name;
            private WellKnownAlphabet alpha;
            private ImmutableWellKnownAlphabetWrapper alphaWrapper;

            String getName() {
                return this.name;
            }

            FiniteAlphabet getAlphabet() {
                return this.alphaWrapper;
            }

            @Override
            public void endTree() {
                this.alpha.addChangeListener(ChangeListener.ALWAYS_VETO, ChangeType.UNKNOWN);
            }

            public AlphabetHandler(String name, FiniteAlphabet parent) {
                this.name = name;
                this.alpha = new WellKnownAlphabet();
                this.alpha.setName(name);
                this.alphaWrapper = new ImmutableWellKnownAlphabetWrapper(this.alpha);
                if (parent != null) {
                    Iterator<Symbol> i = parent.iterator();
                    while (i.hasNext()) {
                        WellKnownAtomicSymbol sym = (WellKnownAtomicSymbol)i.next();
                        try {
                            this.alpha.addSymbol(sym);
                        }
                        catch (Exception ex) {
                            throw new BioError("Couldn't initialize alphabet from parent", ex);
                        }
                        lsidToSymbol.put(sym.getIdentifier(), sym);
                    }
                }
            }

            @Override
            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("alphabet")) {
                    if (localName.equals("symbol")) {
                        String name = attrs.getValue("name");
                        dm.delegate(new SymbolHandler(name));
                    } else if (localName.equals("symbolref")) {
                        String name = attrs.getValue("name");
                        LifeScienceIdentifier lsid = null;
                        try {
                            lsid = LifeScienceIdentifier.valueOf(name);
                        }
                        catch (LifeScienceIdentifierParseException ex) {
                            throw new SAXException("Couldn't form a LSID from " + name);
                        }
                        Symbol sym = (Symbol)lsidToSymbol.get(lsid);
                        if (sym == null) {
                            throw new SAXException("Reference to non-existent symbol " + name);
                        }
                        this.addSymbol(sym);
                    } else if (localName.equals("characterTokenization")) {
                        String name = attrs.getValue("name");
                        boolean caseSensitive = "true".equals(attrs.getValue("caseSensitive"));
                        dm.delegate(new CharacterTokenizationHandler(name, this.alphaWrapper, lsidToSymbol, caseSensitive));
                    } else if (localName.equals("description")) {
                        dm.delegate(new StringElementHandlerBase(){

                            @Override
                            protected void setStringValue(String s) {
                                try {
                                    AlphabetHandler.this.alpha.getAnnotation().setProperty("description", s);
                                }
                                catch (ChangeVetoException ex) {
                                    throw new BioError("Assertion failure: veto while modifying new Annotation", ex);
                                }
                            }
                        });
                    } else {
                        throw new SAXException("Unknown element in alphabetl: " + localName);
                    }
                }
            }

            @Override
            public void endElement(String nsURI, String localName, String qName, StAXContentHandler delegate) throws SAXException {
                if (delegate instanceof SymbolHandler) {
                    SymbolHandler sh = (SymbolHandler)delegate;
                    Symbol symbol = sh.getSymbol();
                    LifeScienceIdentifier lsid = sh.getLSID();
                    lsidToSymbol.put(lsid, symbol);
                    this.addSymbol(symbol);
                } else if (delegate instanceof CharacterTokenizationHandler) {
                    CharacterTokenizationHandler cth = (CharacterTokenizationHandler)delegate;
                    String name = cth.getName();
                    SymbolTokenization toke = cth.getTokenization();
                    this.alpha.putTokenization(name, toke);
                }
            }

            private void addSymbol(Symbol sym) throws SAXException {
                try {
                    this.alpha.addSymbol(sym);
                }
                catch (ChangeVetoException cve) {
                    throw new BioError("Assertion failure: veto while modifying new Alphabet", cve);
                }
                catch (IllegalSymbolException ex) {
                    throw new SAXException("IllegalSymbolException adding symbol to alphabet");
                }
            }
        }

        private class SymbolHandler
        extends StAXContentHandlerBase {
            private String name;
            private LifeScienceIdentifier lsid;
            private Symbol symbol;
            private Annotation annotation = new SmallAnnotation();

            public SymbolHandler(String id) {
                try {
                    this.lsid = LifeScienceIdentifier.valueOf(id);
                    this.name = this.lsid.getObjectId();
                }
                catch (LifeScienceIdentifierParseException ex) {
                    throw new BioError("Malformed LSID - " + this.name, ex);
                }
            }

            @Override
            public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
                if (!localName.equals("symbol")) {
                    if (localName.equals("description")) {
                        dm.delegate(new StringElementHandlerBase(){

                            @Override
                            protected void setStringValue(String s) {
                                try {
                                    SymbolHandler.this.annotation.setProperty("description", s);
                                }
                                catch (ChangeVetoException ex) {
                                    throw new BioError("Assertion failure: veto while modifying new Annotation", ex);
                                }
                            }
                        });
                    } else {
                        throw new SAXException("Unknown element in symbol: " + localName);
                    }
                }
            }

            @Override
            public void endTree() {
                this.symbol = new WellKnownAtomicSymbol(new FundamentalAtomicSymbol(this.name, this.annotation), this.lsid);
            }

            Symbol getSymbol() {
                return this.symbol;
            }

            String getName() {
                return this.name;
            }

            LifeScienceIdentifier getLSID() {
                return this.lsid;
            }
        }
    }
}

