/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.projection;

import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.projection.ProjectionContext;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public final class ProjectedFeatureHolder
extends AbstractFeatureHolder
implements FeatureHolder,
Serializable {
    private final ProjectionContext context;
    private final transient ChangeListener underlyingFeaturesChange = new ChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preChange(ChangeEvent e) throws ChangeVetoException {
            ChangeEvent cev2;
            if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES);
                synchronized (changeSupport) {
                    cs.firePreChangeEvent(cev2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void postChange(ChangeEvent e) {
            ChangeEvent cev2;
            if (ProjectedFeatureHolder.this.hasListeners() && (cev2 = ProjectedFeatureHolder.this.forwardChangeEvent(e)) != null) {
                ChangeSupport cs;
                ChangeSupport changeSupport = cs = ProjectedFeatureHolder.this.getChangeSupport(FeatureHolder.FEATURES);
                synchronized (changeSupport) {
                    cs.firePostChangeEvent(cev2);
                }
            }
        }
    };
    private FeatureHolder topLevelFeatures;

    public ProjectedFeatureHolder(ProjectionContext context) {
        this.context = context;
        context.getUnprojectedFeatures().addChangeListener(this.underlyingFeaturesChange);
    }

    public ProjectionContext getContext() {
        return this.context;
    }

    private FeatureHolder getTopLevelFeatures() {
        if (this.topLevelFeatures == null) {
            this.topLevelFeatures = this.makeProjectionSet(this.context.getUnprojectedFeatures());
        }
        return this.topLevelFeatures;
    }

    public Iterator features() {
        return this.getTopLevelFeatures().features();
    }

    @Override
    public int countFeatures() {
        return this.getTopLevelFeatures().countFeatures();
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getTopLevelFeatures().containsFeature(f);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.getTopLevelFeatures().filter(ff);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        return this.getTopLevelFeatures().filter(ff, recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature createFeature(Feature.Template templ) throws ChangeVetoException, BioException {
        Feature f = null;
        ProjectionContext projectionContext = this.context;
        synchronized (projectionContext) {
            f = this.context.createFeature(templ);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFeature(Feature dyingChild) throws ChangeVetoException, BioException {
        ProjectionContext projectionContext = this.context;
        synchronized (projectionContext) {
            this.context.removeFeature(dyingChild);
        }
    }

    @Override
    public FeatureFilter getSchema() {
        return this.getTopLevelFeatures().getSchema();
    }

    protected FeatureHolder makeProjectionSet(FeatureHolder fh) {
        return this.context.projectFeatures(fh);
    }

    protected ChangeEvent forwardChangeEvent(ChangeEvent cev) {
        return new ChangeEvent(this, cev.getType(), cev.getChange(), cev.getPrevious(), cev);
    }
}

