/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game12;

import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game12.GAMEFeatureSpanHandler;
import org.biojava.bio.seq.io.game12.GAMEPropertyHandler;
import org.biojava.bio.seq.io.game12.StAXFeatureHandler;
import org.biojava.bio.seq.io.game12.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StringElementHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GAMEFeatureSetHandler
extends StAXFeatureHandler {
    private String featureSetType;
    StrandedFeature.Template template;
    Location transcript;
    Location translateOffset;
    StrandedFeature.Strand transcriptStrand;
    public static final StAXHandlerFactory GAME_FEATURE_SET_HANDLER_FACTORY = new StAXHandlerFactory(){

        @Override
        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEFeatureSetHandler(staxenv);
        }
    };

    GAMEFeatureSetHandler(StAXFeatureHandler staxenv) {
        super(staxenv);
        super.addHandler(new ElementRecognizer.ByLocalName("name"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new NameHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("type"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new TypeHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("author"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new AuthorHandler();
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("feature_span"), new StAXHandlerFactory(){

            @Override
            public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
                return new FeatureSpanHandler(staxenv);
            }
        });
        super.addHandler(new ElementRecognizer.ByLocalName("property"), GAMEPropertyHandler.GAME_PROPERTY_HANDLER_FACTORY);
    }

    @Override
    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) throws SAXException {
        String id = attrs.getValue("id");
        String produces_seq = attrs.getValue("produces_seq");
        this.template = new StrandedFeature.Template();
        this.template.annotation = new SimpleAnnotation();
        try {
            try {
                if (id != null) {
                    this.template.annotation.setProperty("id", id);
                }
                if (produces_seq != null) {
                    this.template.annotation.setProperty("produces_seq", produces_seq);
                }
            }
            catch (ChangeVetoException cve) {
                cve.printStackTrace();
                throw new SAXException("unexpected ChangeVetoException when setting id!");
            }
            this.listener.startFeature(this.template);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEFeatureSetHandler.");
        }
    }

    @Override
    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
        if (!this.featureSetType.equals("transcript")) {
            System.err.println("<feature_set> of type " + this.featureSetType + " encountered when transcript expected");
        }
        this.template.type = this.featureSetType;
        this.template.source = "";
        this.template.location = this.transcript;
        this.template.strand = this.transcriptStrand;
        try {
            try {
                if (this.translateOffset != null) {
                    this.template.annotation.setProperty("translate_offset", this.translateOffset);
                }
            }
            catch (ChangeVetoException cve) {
                cve.printStackTrace();
                throw new SAXException("unexpected ChangeVetoException when setting id!");
            }
            this.listener.endFeature();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            throw new SAXException("error in GAMEFeatureSetHandler.");
        }
    }

    private class AuthorHandler
    extends StringElementHandlerBase {
        private AuthorHandler() {
        }

        @Override
        protected void setStringValue(String s) {
        }
    }

    private class TypeHandler
    extends StringElementHandlerBase {
        private TypeHandler() {
        }

        @Override
        protected void setStringValue(String s) {
            GAMEFeatureSetHandler.this.featureSetType = s.trim();
        }
    }

    private class NameHandler
    extends StringElementHandlerBase {
        private NameHandler() {
        }

        @Override
        protected void setStringValue(String s) {
        }
    }

    private class FeatureSpanHandler
    extends GAMEFeatureSpanHandler {
        private FeatureSpanHandler(StAXFeatureHandler staxenv) {
            super(staxenv);
        }

        @Override
        public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler contentHandler) throws SAXException {
            super.endElementHandler(nsURI, localName, qName, contentHandler);
            if (this.featureSpanType.equals("exon")) {
                if (GAMEFeatureSetHandler.this.transcript == null) {
                    GAMEFeatureSetHandler.this.transcript = this.featureSpanLoc;
                    GAMEFeatureSetHandler.this.transcriptStrand = this.featureSpanStrand;
                } else {
                    if (GAMEFeatureSetHandler.this.transcriptStrand != this.featureSpanStrand) {
                        System.err.println("exons on differing strands!");
                    }
                    GAMEFeatureSetHandler.this.transcript = LocationTools.union(GAMEFeatureSetHandler.this.transcript, this.featureSpanLoc);
                }
            } else if (this.featureSpanType.equals("translate offset")) {
                if (GAMEFeatureSetHandler.this.translateOffset != null) {
                    System.err.println("translate offset multiply defined.");
                } else {
                    if (GAMEFeatureSetHandler.this.transcriptStrand == null) {
                        GAMEFeatureSetHandler.this.transcriptStrand = this.featureSpanStrand;
                    } else if (GAMEFeatureSetHandler.this.transcriptStrand != this.featureSpanStrand) {
                        System.err.println("exons on differing strands!");
                    }
                    GAMEFeatureSetHandler.this.translateOffset = this.featureSpanLoc;
                }
            }
        }
    }
}

