/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import org.xml.sax.Attributes;

public interface ElementRecognizer {
    public static final ElementRecognizer ALL = new AllElementRecognizer();

    public boolean filterStartElement(String var1, String var2, String var3, Attributes var4);

    public static class ByLocalName
    implements ElementRecognizer {
        private String localName;

        public ByLocalName(String localName) {
            this.localName = localName;
        }

        @Override
        public boolean filterStartElement(String nsURI, String localName, String qName, Attributes attrs) {
            return localName.equals(this.localName);
        }
    }

    public static class ByNSName
    implements ElementRecognizer {
        private String nsURI;
        private String localName;

        public ByNSName(String nsURI, String localName) {
            this.nsURI = nsURI;
            this.localName = localName;
        }

        @Override
        public boolean filterStartElement(String nsURI, String localName, String qName, Attributes attrs) {
            return localName.equals(this.localName) && nsURI.equals(this.nsURI);
        }
    }

    public static class HasAttribute
    implements ElementRecognizer {
        private String attributeName;

        public HasAttribute(String name) {
            this.attributeName = name;
        }

        @Override
        public boolean filterStartElement(String nsURI, String localName, String qName, Attributes attrs) {
            return attrs.getValue(this.attributeName) != null;
        }
    }

    public static class AllElementRecognizer
    implements ElementRecognizer {
        @Override
        public boolean filterStartElement(String nsURI, String localName, String qName, Attributes attrs) {
            return true;
        }
    }
}

