/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.agave;

import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.agave.AGAVEAnnotFilter;
import org.biojava.bio.seq.io.agave.AGAVEAnnotFilterFactory;
import org.biojava.bio.seq.io.agave.AGAVEDbId;
import org.biojava.bio.seq.io.agave.SimpleAnnotFilter;
import org.biojava.bio.seq.io.agave.UtilHelper;

public class Embl2AgaveAnnotFilter
extends SimpleAnnotFilter {
    public static final AGAVEAnnotFilterFactory EMBL_AGAVE_ANNOT_FILTER_FACTORY = new AGAVEAnnotFilterFactory(){

        @Override
        public AGAVEAnnotFilter getInstance() {
            return new Embl2AgaveAnnotFilter();
        }
    };

    Embl2AgaveAnnotFilter() {
    }

    @Override
    public String getAccession(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "AC");
    }

    @Override
    public String getKeyword(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "KW");
    }

    @Override
    public String getOrganism(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "OC");
    }

    @Override
    public String getDescription(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "DE");
    }

    @Override
    public String getNote(Annotation annot) {
        return "RN:" + (String)UtilHelper.getProperty(annot, "RN") + "  \nRP:" + (String)UtilHelper.getProperty(annot, "RP") + "  \nRA:" + (String)UtilHelper.getProperty(annot, "RA") + "  \nRT:" + (String)UtilHelper.getProperty(annot, "RT") + "  \nRL:" + (String)UtilHelper.getProperty(annot, "RL") + "  \n";
    }

    @Override
    public String getVersion(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "SV");
    }

    @Override
    public String getOS(Annotation annot) {
        return (String)UtilHelper.getProperty(annot, "OS");
    }

    @Override
    public String getMolType(Annotation annot) {
        String id = (String)UtilHelper.getProperty(annot, "ID");
        if (id.indexOf("rRNA") != -1) {
            return "rRNA";
        }
        if (id.indexOf("tRNA") != -1) {
            return "tRNA";
        }
        if (id.indexOf("mRNA") != -1) {
            return "mRNA";
        }
        if (id.indexOf("RNA") != -1) {
            return "RNA";
        }
        if (id.indexOf("cDNA") != -1) {
            return "cDNA";
        }
        if (id.indexOf("DNA") != -1) {
            return "DNA";
        }
        if (id.indexOf("PROTEIN") != -1) {
            return "AA";
        }
        return null;
    }

    @Override
    public AGAVEDbId getDbId(Annotation annot) {
        String AC = (String)UtilHelper.getProperty(annot, "AC");
        String SV = (String)UtilHelper.getProperty(annot, "SV");
        if (AC != null && SV != null) {
            AGAVEDbId dbid = new AGAVEDbId();
            dbid.setId(AC);
            dbid.setDbCode(SV);
            return dbid;
        }
        return null;
    }
}

