/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SequenceBuilder;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceBuilderFilter;
import org.biojava.bio.taxa.CircularReferenceException;
import org.biojava.bio.taxa.EbiFormat;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.bio.taxa.TaxonParser;
import org.biojava.utils.ChangeVetoException;

public class OrganismParser
extends SequenceBuilderFilter {
    public static final String PROPERTY_ORGANISM = OrganismParser.class + ":organism";
    private final TaxonFactory taxonFactory;
    private final TaxonParser taxonParser;
    private final String sciNameKey;
    private final String commonNameKey;
    private final String ncbiTaxonKey;
    private String fullName;
    private String commonName;
    private String ncbiTaxon;

    public OrganismParser(SequenceBuilder delegate, TaxonFactory taxonFactory, TaxonParser taxonParser, String sciNameKey, String commonNameKey, String ncbiTaxonKey) {
        super(delegate);
        this.taxonFactory = taxonFactory;
        this.taxonParser = taxonParser;
        this.sciNameKey = sciNameKey;
        this.commonNameKey = commonNameKey;
        this.ncbiTaxonKey = ncbiTaxonKey;
    }

    @Override
    public void addSequenceProperty(Object sciNameKey, Object value) throws ParseException {
        if (this.sciNameKey.equals(sciNameKey)) {
            this.fullName = this.fullName == null ? value.toString() : this.fullName + " " + value;
        } else if (this.commonNameKey.equals(sciNameKey)) {
            this.commonName = value.toString();
        } else if (this.ncbiTaxonKey.equals(sciNameKey)) {
            int sc;
            String tid = value.toString();
            int eq = tid.indexOf("=");
            if (eq >= 0) {
                tid = tid.substring(eq + 1);
            }
            if ((sc = tid.indexOf(";")) >= 0) {
                tid = tid.substring(0, sc);
            }
            this.ncbiTaxon = this.ncbiTaxon == null ? tid : this.ncbiTaxon + tid;
        } else {
            this.getDelegate().addSequenceProperty(sciNameKey, value);
        }
    }

    @Override
    public void endSequence() throws ParseException {
        try {
            StringTokenizer stok;
            Taxon taxon = this.taxonParser.parse(this.taxonFactory, this.fullName);
            if (this.commonName != null && taxon.getCommonName() == null) {
                try {
                    taxon.setCommonName(this.commonName);
                }
                catch (ChangeVetoException cve) {
                    throw new ParseException(cve, "Failed to build Taxon");
                }
            }
            if ((stok = new StringTokenizer(this.ncbiTaxon, ",")).countTokens() == 1) {
                taxon.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, this.ncbiTaxon);
            } else {
                ArrayList<String> tl = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    tl.add(stok.nextToken());
                }
                taxon.getAnnotation().setProperty(EbiFormat.PROPERTY_NCBI_TAXON, tl);
            }
            this.getDelegate().addSequenceProperty(PROPERTY_ORGANISM, taxon);
        }
        catch (ChangeVetoException cve) {
            throw new ParseException(cve, "Could not parse organism: " + this.fullName);
        }
        catch (CircularReferenceException cre) {
            throw new ParseException(cre);
        }
    }

    public static class Factory
    implements SequenceBuilderFactory,
    Serializable {
        private SequenceBuilderFactory delegateFactory;
        private String sciNameKey;
        private String commonNameKey;
        private String ncbiTaxonKey;
        private TaxonFactory taxonFactory;
        private TaxonParser taxonParser;

        public Factory(SequenceBuilderFactory delegateFactory, TaxonFactory taxonFactory, TaxonParser taxonParser, String sciNameKey, String commonNameKey, String ncbiTaxonKey) {
            this.delegateFactory = delegateFactory;
            this.taxonFactory = taxonFactory;
            this.taxonParser = taxonParser;
            this.sciNameKey = sciNameKey;
            this.commonNameKey = commonNameKey;
            this.ncbiTaxonKey = ncbiTaxonKey;
        }

        @Override
        public SequenceBuilder makeSequenceBuilder() {
            return new OrganismParser(this.delegateFactory.makeSequenceBuilder(), this.taxonFactory, this.taxonParser, this.sciNameKey, this.commonNameKey, this.ncbiTaxonKey);
        }
    }
}

