/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.utils.AssertionFailure;

public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static Feature.Template instantiateTemplate(Feature feat) throws BioException {
        Feature.Template tmpl = TemplateUtils.searchForTemplate(feat.getClass());
        if (tmpl == null) {
            throw new AssertionFailure("Could not find template for feature class: " + feat.getClass());
        }
        return tmpl;
    }

    private static Feature.Template searchForTemplate(Class fClass) throws BioException {
        if (fClass.isInterface() && Feature.class.isAssignableFrom(fClass)) {
            return TemplateUtils.instantiateTemplate(fClass);
        }
        Class<?>[] interfaces = fClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Feature.Template tmpl = TemplateUtils.searchForTemplate(interfaces[i]);
            if (tmpl == null) continue;
            return tmpl;
        }
        Class parent = fClass.getSuperclass();
        if (parent != null) {
            return TemplateUtils.searchForTemplate(parent);
        }
        return null;
    }

    private static Feature.Template instantiateTemplate(Class fClass) throws BioException {
        Class<?>[] declClasses = fClass.getDeclaredClasses();
        for (int i = 0; i < declClasses.length; ++i) {
            if (!declClasses[i].getName().equals(fClass.getName() + "$Template")) continue;
            try {
                return (Feature.Template)declClasses[i].newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new BioException("Expected template no-args constructor to be accessible", iae);
            }
            catch (InstantiationException ie) {
                throw new BioException("Failed to execute no-args constructor", ie);
            }
        }
        return null;
    }

    public static void populate(Feature.Template templ, Feature feat) throws BioException {
        Field[] fields = templ.getClass().getFields();
        Method[] methods = feat.getClass().getMethods();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String fName = field.getName();
            String methName = "get" + fName.substring(0, 1).toUpperCase() + fName.substring(1);
            Method method = null;
            for (int j = 0; j < methods.length; ++j) {
                Method meth = methods[j];
                if (!methods[j].getName().equals(methName)) continue;
                method = meth;
            }
            if (method == null) {
                throw new BioException("Expecting to find a method named: " + methName);
            }
            try {
                field.set(templ, method.invoke((Object)feat, new Object[0]));
                continue;
            }
            catch (Exception e) {
                throw new BioError("Couldn't access template fields", e);
            }
        }
    }

    public static Feature.Template makeTemplate(Feature feat) throws BioException {
        Feature.Template templ = TemplateUtils.instantiateTemplate(feat);
        TemplateUtils.populate(templ, feat);
        return templ;
    }
}

