/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import org.biojava.bio.alignment.Alignment;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.homol.SimilarityPairFeature;
import org.biojava.bio.seq.impl.SimpleStrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class SimpleSimilarityPairFeature
extends SimpleStrandedFeature
implements SimilarityPairFeature {
    private SimilarityPairFeature sibling;
    private Alignment alignment;
    private double score;

    public SimpleSimilarityPairFeature(Sequence sourceSeq, FeatureHolder parent, SimilarityPairFeature.Template template) throws IllegalAlphabetException {
        super(sourceSeq, parent, template);
        this.sibling = template.sibling;
        this.alignment = template.alignment;
        this.score = template.score;
    }

    @Override
    public SimilarityPairFeature getSibling() {
        return this.sibling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSibling(SimilarityPairFeature sibling) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SimilarityPairFeature.SIBLING);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SimilarityPairFeature.SIBLING, this.sibling, sibling);
                cs.firePreChangeEvent(ce);
                this.sibling = sibling;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.sibling = sibling;
        }
    }

    @Override
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public Feature.Template makeTemplate() {
        SimilarityPairFeature.Template ft = new SimilarityPairFeature.Template();
        this.fillTemplate(ft);
        return ft;
    }

    protected void fillTemplate(SimilarityPairFeature.Template ft) {
        super.fillTemplate(ft);
        ft.sibling = this.getSibling();
        ft.alignment = this.getAlignment();
        ft.score = this.getScore();
    }

    @Override
    public String toString() {
        return super.toString() + " [score " + this.score + "]";
    }
}

