/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.distributed;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.distributed.DistDataSource;
import org.biojava.bio.seq.distributed.DistProjectionContext;
import org.biojava.bio.seq.distributed.DistributedSequenceDB;
import org.biojava.bio.seq.projection.ProjectedFeatureHolder;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class DistributedSequence
extends AbstractChangeable
implements Sequence {
    private DistributedSequenceDB db;
    private DistDataSource seqSource;
    private Set featureSources;
    private String id;
    private SymbolList symbols;
    private MergeFeatureHolder mfh;
    private transient ChangeListener dsListener;
    private FeatureHolder components = null;

    DistributedSequence(String id, DistributedSequenceDB db, DistDataSource seqSource, Set featureSources) {
        this.id = id;
        this.seqSource = seqSource;
        this.featureSources = featureSources;
        this.db = db;
        this.installListener();
    }

    private void installListener() {
        this.dsListener = new ChangeListener(){

            @Override
            public void preChange(ChangeEvent cev) throws ChangeVetoException {
                if (cev.getPrevious() == DistributedSequence.this.seqSource) {
                    throw new ChangeVetoException(cev, "Can't remove this datasource, since it is providing sequence data");
                }
                if (DistributedSequence.this.hasListeners()) {
                    DistributedSequence.this.getChangeSupport(ChangeType.UNKNOWN).firePreChangeEvent(this.makeChainedEvent(cev));
                }
            }

            @Override
            public void postChange(ChangeEvent cev) {
                if (cev.getType() == DistributedSequenceDB.DATASOURCE_SELECTION) {
                    if (cev.getChange() != null && cev.getPrevious() == null) {
                        DistDataSource added = (DistDataSource)cev.getChange();
                        DistributedSequence.this.featureSources.add(added);
                    } else if (cev.getChange() == null && cev.getPrevious() != null) {
                        DistDataSource removed = (DistDataSource)cev.getChange();
                        DistributedSequence.this.featureSources.remove(removed);
                    }
                }
                DistributedSequence.this.mfh = null;
                if (DistributedSequence.this.hasListeners()) {
                    DistributedSequence.this.getChangeSupport(ChangeType.UNKNOWN).firePostChangeEvent(this.makeChainedEvent(cev));
                }
            }

            private ChangeEvent makeChainedEvent(ChangeEvent cev) {
                return new ChangeEvent(DistributedSequence.this, FeatureHolder.FEATURES, null, null, cev);
            }
        };
        this.db.addChangeListener(this.dsListener, DistributedSequenceDB.DATASOURCE);
    }

    public DistributedSequenceDB getSequenceDB() {
        return this.db;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public String getURN() {
        return this.id;
    }

    @Override
    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.getSymbols().getAlphabet();
    }

    @Override
    public int length() {
        return this.getSymbols().length();
    }

    @Override
    public Symbol symbolAt(int i) {
        return this.getSymbols().symbolAt(i);
    }

    @Override
    public SymbolList subList(int start, int end) {
        return this.getSymbols().subList(start, end);
    }

    public List toList() {
        return this.getSymbols().toList();
    }

    public Iterator iterator() {
        return this.getSymbols().iterator();
    }

    @Override
    public String seqString() {
        return this.getSymbols().seqString();
    }

    @Override
    public String subStr(int start, int end) {
        return this.getSymbols().subStr(start, end);
    }

    @Override
    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence in EGADS -- or at least not yet...");
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (recurse) {
            MergeFeatureHolder results = new MergeFeatureHolder();
            try {
                results.addFeatureHolder(this.getFeatures().filter(new FeatureFilter.And(new FeatureFilter.Not(new FeatureFilter.ByAncestor(new FeatureFilter.ByClass(ComponentFeature.class))), ff), recurse));
                if (this.components == null) {
                    this.components = this.getFeatures().filter(new FeatureFilter.And(FeatureFilter.top_level, new FeatureFilter.ByClass(ComponentFeature.class)));
                }
                Iterator<Feature> i = this.components.features();
                while (i.hasNext()) {
                    FeatureHolder fh = i.next().filter(ff);
                    if (fh.countFeatures() <= 0) continue;
                    results.addFeatureHolder(fh);
                }
            }
            catch (Exception ex) {
                throw new BioRuntimeException(ex);
            }
            return results;
        }
        return this.getFeatures().filter(ff, recurse);
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff) {
        return this.filter(ff, true);
    }

    @Override
    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence in EGADS -- or at least not yet...");
    }

    @Override
    public Feature createFeature(Feature.Template f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't edit sequence in EGADS -- or at least not yet...");
    }

    @Override
    public boolean containsFeature(Feature f) {
        return this.getFeatures().containsFeature(f);
    }

    @Override
    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    protected SymbolList getSymbols() {
        if (this.symbols == null) {
            try {
                this.symbols = this.seqSource.getSequence(this.id);
            }
            catch (BioException ex) {
                throw new BioRuntimeException(ex);
            }
        }
        return this.symbols;
    }

    protected FeatureHolder getFeatures() {
        if (this.mfh == null) {
            this.mfh = new MergeFeatureHolder();
            for (DistDataSource dds : this.featureSources) {
                try {
                    SmallAnnotation ann = new SmallAnnotation();
                    ann.setProperty("source", dds);
                    this.mfh.addFeatureHolder(new ProjectedFeatureHolder(new DistProjectionContext(dds.getFeatures(this.id, FeatureFilter.all, false), this, ann)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.mfh;
    }

    @Override
    public FeatureFilter getSchema() {
        return FeatureFilter.all;
    }
}

