/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.seq.AbstractFeatureHolder;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;

public class MergeFeatureHolder
extends AbstractFeatureHolder
implements Serializable {
    private List featureHolders;

    public MergeFeatureHolder() {
        this.featureHolders = new ArrayList();
    }

    private MergeFeatureHolder(List m) {
        this.featureHolders = m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatureHolder(FeatureHolder fh) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.featureHolders.add(fh);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FeatureHolder.FEATURES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, FeatureHolder.FEATURES);
                changeSupport.firePreChangeEvent(ce);
                this.featureHolders.add(fh);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeatureHolder(FeatureHolder fh) throws ChangeVetoException {
        if (!this.hasListeners()) {
            this.featureHolders.remove(fh);
        } else {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(FeatureHolder.FEATURES);
            synchronized (changeSupport2) {
                ChangeEvent ce = new ChangeEvent(this, FeatureHolder.FEATURES);
                changeSupport.firePreChangeEvent(ce);
                this.featureHolders.remove(fh);
                changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public int countFeatures() {
        int fc = 0;
        Iterator i = this.featureHolders.iterator();
        while (i.hasNext()) {
            fc += ((FeatureHolder)i.next()).countFeatures();
        }
        return fc;
    }

    @Override
    public boolean containsFeature(Feature f) {
        for (FeatureHolder subFH : this.featureHolders) {
            FeatureFilter membership = subFH.getSchema();
            if (!membership.accept(f) || !subFH.containsFeature(f)) continue;
            return true;
        }
        return false;
    }

    public Iterator features() {
        return new MFHIterator();
    }

    @Override
    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        ArrayList<FeatureHolder> results = new ArrayList<FeatureHolder>();
        for (FeatureHolder fh : this.featureHolders) {
            FeatureFilter mf = fh.getSchema();
            if (recurse && !FilterUtils.areProperSubset(mf, FeatureFilter.leaf) ? FilterUtils.areDisjoint(new FeatureFilter.Or(mf, new FeatureFilter.ByAncestor(mf)), ff) : FilterUtils.areDisjoint(mf, ff)) continue;
            FeatureHolder filterResult = fh.filter(ff, recurse);
            results.add(filterResult);
        }
        if (results.size() == 0) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (results.size() == 1) {
            return (FeatureHolder)results.get(0);
        }
        return new MergeFeatureHolder(results);
    }

    @Override
    public FeatureFilter getSchema() {
        FeatureFilter[] filters = new FeatureFilter[this.featureHolders.size()];
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = ((FeatureHolder)this.featureHolders.get(i)).getSchema();
        }
        return FilterUtils.or(filters);
    }

    private class MFHIterator
    implements Iterator {
        private Iterator fhIterator;
        private Iterator fIterator;

        public MFHIterator() {
            this.fhIterator = MergeFeatureHolder.this.featureHolders.iterator();
            this.fIterator = this.fhIterator.hasNext() ? ((FeatureHolder)this.fhIterator.next()).features() : Collections.EMPTY_SET.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.fIterator.hasNext()) {
                return true;
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.hasNext();
            }
            return false;
        }

        public Object next() {
            if (this.fIterator.hasNext()) {
                return this.fIterator.next();
            }
            if (this.fhIterator.hasNext()) {
                this.fIterator = ((FeatureHolder)this.fhIterator.next()).features();
                return this.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

