/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.ViewSequence;
import org.biojava.bio.symbol.CircularLocation;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class CircularView
extends ViewSequence {
    public CircularView(Sequence seq, FeatureRealizer fr) {
        super(seq, fr);
    }

    public CircularView(Sequence seq) {
        super(seq);
    }

    private int realValue(int val) {
        if ((val %= this.length()) < 1) {
            val = this.length() + val;
        }
        return val;
    }

    @Override
    public Symbol symbolAt(int index) {
        return super.symbolAt(this.realValue(index));
    }

    @Override
    public String subStr(int start, int end) {
        if ((start = this.realValue(start)) <= (end = this.realValue(end))) {
            return super.subStr(start, end);
        }
        String toEnd = super.subStr(start, super.length());
        String fromStart = super.subStr(1, end);
        return toEnd + fromStart;
    }

    @Override
    public Feature createFeature(Feature.Template template) throws ChangeVetoException, BioException {
        Location loc = template.location;
        if (loc.getMax() > this.length() && !(loc instanceof CircularLocation)) {
            throw new BioException("Only CircularLocations may exceed sequence length");
        }
        Feature f = this.realizeFeature(this, template);
        ((SimpleFeatureHolder)this.getAddedFeatures()).addFeature(f);
        return f;
    }

    @Override
    public SymbolList subList(int start, int end) {
        if ((start = this.realValue(start)) <= (end = this.realValue(end))) {
            return super.subList(start, end);
        }
        SimpleSymbolList fromStart = new SimpleSymbolList(super.subList(1, end));
        SimpleSymbolList toEnd = new SimpleSymbolList(super.subList(start, this.length()));
        Edit edit = new Edit(toEnd.length() + 1, 0, fromStart);
        try {
            toEnd.edit(edit);
        }
        catch (Exception e) {
            throw new BioError("Couldn't construct subList, this shouldn't happen", e);
        }
        return toEnd;
    }
}

