/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.search.BioMatcher;
import org.biojava.bio.search.BioPattern;
import org.biojava.bio.search.SeqContentMatcher;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class SeqContentPattern
implements BioPattern {
    private final AlphabetIndex index;
    private final int[] minCounts;
    private final int[] maxCounts;
    private int length;

    public SeqContentPattern(FiniteAlphabet alpha) {
        this.index = AlphabetManager.getAlphabetIndex(alpha);
        this.minCounts = new int[alpha.size()];
        this.maxCounts = new int[alpha.size()];
        for (int i = 0; i < this.minCounts.length; ++i) {
            this.minCounts[i] = 0;
            this.maxCounts[i] = -1;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMinCounts(AtomicSymbol as, int count) throws IllegalSymbolException {
        this.minCounts[this.index.indexForSymbol((Symbol)as)] = count;
    }

    public int getMinCounts(AtomicSymbol as) throws IllegalSymbolException {
        return this.minCounts[this.index.indexForSymbol(as)];
    }

    public void setMaxCounts(AtomicSymbol as, int count) throws IllegalSymbolException {
        this.maxCounts[this.index.indexForSymbol((Symbol)as)] = count;
    }

    public int getMaxCounts(AtomicSymbol as) throws IllegalSymbolException {
        int c = this.maxCounts[this.index.indexForSymbol(as)];
        if (c == -1) {
            return this.length;
        }
        return c;
    }

    @Override
    public BioMatcher matcher(SymbolList symList) throws IllegalAlphabetException {
        if (symList.getAlphabet() != this.index.getAlphabet()) {
            throw new IllegalAlphabetException("Attempted to search symbol list over " + symList.getAlphabet() + " but the search parameters only accept " + this.index.getAlphabet());
        }
        int[] minCounts = new int[this.minCounts.length];
        int[] maxCounts = new int[this.maxCounts.length];
        for (int i = 0; i < minCounts.length; ++i) {
            minCounts[i] = this.minCounts[i];
            int c = this.maxCounts[i];
            maxCounts[i] = c == -1 ? this.length : c;
        }
        return new SeqContentMatcher(symList, this.index, minCounts, maxCounts, this.length);
    }
}

