/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Iterator;
import org.biojava.bio.search.BioMatcher;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AssertionFailure;

class SeqContentMatcher
implements BioMatcher {
    private final AlphabetIndex index;
    private final SymbolList symList;
    private final int[] minCounts;
    private final int[] maxCounts;
    private final int length;
    private int pos;
    private int[] curCounts;

    SeqContentMatcher(SymbolList symList, AlphabetIndex index, int[] minCounts, int[] maxCounts, int length) {
        this.symList = symList;
        this.index = index;
        this.minCounts = minCounts;
        this.maxCounts = maxCounts;
        this.length = length;
        this.curCounts = new int[minCounts.length];
        this.pos = 0;
    }

    @Override
    public boolean find() {
        try {
            AtomicSymbol as;
            Symbol s;
            if (this.pos == 0) {
                if (this.length > this.symList.length()) {
                    return false;
                }
                for (int i = 1; i <= this.length; ++i) {
                    s = this.symList.symbolAt(i);
                    if (s instanceof AtomicSymbol) {
                        int n = this.index.indexForSymbol(s);
                        this.curCounts[n] = this.curCounts[n] + 1;
                        continue;
                    }
                    Iterator<Symbol> si = ((FiniteAlphabet)s.getMatches()).iterator();
                    while (si.hasNext()) {
                        as = (AtomicSymbol)si.next();
                        int n = this.index.indexForSymbol(as);
                        this.curCounts[n] = this.curCounts[n] + 1;
                    }
                }
                this.pos = 1;
                if (this.acceptable()) {
                    return true;
                }
            }
            ++this.pos;
            int ourMax = this.symList.length() - this.length + 1;
            while (this.pos <= ourMax) {
                Iterator<Symbol> i;
                s = this.symList.symbolAt(this.pos - 1);
                if (s instanceof AtomicSymbol) {
                    int n = this.index.indexForSymbol(s);
                    this.curCounts[n] = this.curCounts[n] - 1;
                } else {
                    i = ((FiniteAlphabet)s.getMatches()).iterator();
                    while (i.hasNext()) {
                        as = (AtomicSymbol)i.next();
                        int n = this.index.indexForSymbol(as);
                        this.curCounts[n] = this.curCounts[n] - 1;
                    }
                }
                s = this.symList.symbolAt(this.pos + this.length - 1);
                if (s instanceof AtomicSymbol) {
                    int n = this.index.indexForSymbol(s);
                    this.curCounts[n] = this.curCounts[n] + 1;
                } else {
                    i = ((FiniteAlphabet)s.getMatches()).iterator();
                    while (i.hasNext()) {
                        as = (AtomicSymbol)i.next();
                        int n = this.index.indexForSymbol(as);
                        this.curCounts[n] = this.curCounts[n] + 1;
                    }
                }
                if (this.acceptable()) {
                    return true;
                }
                ++this.pos;
            }
            this.pos = this.symList.length() + 1;
            return false;
        }
        catch (IllegalSymbolException ise) {
            throw new AssertionFailure("It should not be possible for the wrong symbols to be here", ise);
        }
    }

    private boolean acceptable() {
        for (int i = 0; i < this.curCounts.length; ++i) {
            int c = this.curCounts[i];
            if (this.minCounts[i] > c) {
                return false;
            }
            if (this.maxCounts[i] >= c) continue;
            return false;
        }
        return true;
    }

    @Override
    public int start() {
        if (this.pos == 0) {
            throw new IllegalStateException("Can't call start() before find()");
        }
        if (this.pos > this.symList.length()) {
            throw new IllegalStateException("Can't call start() after find() has returned false");
        }
        return this.pos;
    }

    @Override
    public int end() {
        if (this.pos == 0) {
            throw new IllegalStateException("Can't call end() before find()");
        }
        if (this.pos > this.symList.length()) {
            throw new IllegalStateException("Can't call end() after find() has returned false");
        }
        return this.pos + this.length - 1;
    }

    @Override
    public SymbolList group() {
        if (this.pos == 0) {
            throw new IllegalStateException("Can't call group() before find()");
        }
        if (this.pos > this.symList.length()) {
            throw new IllegalStateException("Can't call group() after find() has returned false");
        }
        return this.symList.subList(this.pos, this.pos + this.length - 1);
    }
}

