/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import org.biojava.bio.search.BioMatcher;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class MaxMismatchMatcher
implements BioMatcher {
    private final Symbol[] patternSymbol;
    private final SymbolList seq;
    private final int patLength;
    private final int maxPatternSymbolIdx;
    private final int seqLength;
    private final int minMatches;
    private final boolean[] ambiguousPosition;
    private boolean hasAmbiguity = false;
    private final int[] matches;
    private int pos;

    MaxMismatchMatcher(SymbolList seq, SymbolList pattern, int mismatches) {
        int i;
        this.seq = seq;
        this.patLength = pattern.length();
        this.maxPatternSymbolIdx = this.patLength - 1;
        this.seqLength = seq.length();
        this.minMatches = this.patLength - mismatches;
        this.patternSymbol = new Symbol[this.patLength];
        this.ambiguousPosition = new boolean[this.patLength];
        for (i = 0; i < this.patLength; ++i) {
            this.patternSymbol[i] = pattern.symbolAt(this.patLength - i);
            if (!(this.patternSymbol[i] instanceof BasisSymbol)) continue;
            this.ambiguousPosition[i] = true;
            this.hasAmbiguity = true;
        }
        this.matches = new int[this.patLength];
        for (i = 0; i < this.matches.length; ++i) {
            this.matches[i] = 0;
        }
        this.pos = 1;
    }

    @Override
    public boolean find() {
        if (this.pos >= this.seq.length()) {
            return false;
        }
        while (this.pos <= this.seqLength) {
            if (this.addSymbol()) {
                ++this.pos;
                return true;
            }
            ++this.pos;
        }
        return false;
    }

    private boolean addSymbol() {
        Symbol sym = this.seq.symbolAt(this.pos);
        if (this.hasAmbiguity) {
            for (int i = 0; i < this.maxPatternSymbolIdx; ++i) {
                int idx = (this.pos + i) % this.patLength;
                if (this.ambiguousPosition[i]) {
                    if (!this.patternSymbol[i].getMatches().contains(sym)) continue;
                    int n = idx;
                    this.matches[n] = this.matches[n] + 1;
                    continue;
                }
                if (sym != this.patternSymbol[i]) continue;
                int n = idx;
                this.matches[n] = this.matches[n] + 1;
            }
        } else {
            for (int i = 0; i < this.maxPatternSymbolIdx; ++i) {
                int idx = (this.pos + i) % this.patLength;
                if (sym != this.patternSymbol[i]) continue;
                int n = idx;
                this.matches[n] = this.matches[n] + 1;
            }
        }
        this.matches[(this.pos + this.maxPatternSymbolIdx) % this.patLength] = sym == this.patternSymbol[this.maxPatternSymbolIdx] ? 1 : 0;
        return this.matches[this.pos % this.patLength] >= this.minMatches;
    }

    @Override
    public int start() {
        return this.pos - this.matches.length;
    }

    @Override
    public int end() {
        return this.pos - 1;
    }

    @Override
    public SymbolList group() {
        return this.seq.subList(this.start(), this.end());
    }

    public int mismatchCount() {
        return this.patLength - this.matches[(this.pos - 1) % this.patLength];
    }
}

