/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.tagvalue;

import java.util.List;
import org.biojava.bio.program.tagvalue.ChangeTable;
import org.biojava.bio.program.tagvalue.SimpleTagValueWrapper;
import org.biojava.bio.program.tagvalue.TagValueContext;
import org.biojava.bio.program.tagvalue.TagValueListener;
import org.biojava.utils.ParserException;

public class ValueChanger
extends SimpleTagValueWrapper {
    private ChangeTable.Changer defaultC;
    private ChangeTable.Splitter defaultS;
    private ChangeTable changeTable;
    private ChangeTable.Changer changer;
    private ChangeTable.Splitter splitter;

    public ValueChanger(TagValueListener delegate) {
        super(delegate);
    }

    public ValueChanger(TagValueListener delegate, ChangeTable changeTable) {
        super(delegate);
        this.changeTable = changeTable;
    }

    public void setDefaultChanger(ChangeTable.Changer c) {
        this.defaultC = c;
    }

    public ChangeTable.Changer getDefaultChanger() {
        return this.defaultC;
    }

    public void setDefaultSplitter(ChangeTable.Splitter s) {
        this.defaultS = s;
    }

    public ChangeTable.Splitter getDefaultSplitter() {
        return this.defaultS;
    }

    public ChangeTable getChangeTable() {
        return this.changeTable;
    }

    public void setChangeTable(ChangeTable changeTable) {
        this.changeTable = changeTable;
    }

    @Override
    public void startTag(Object tag) throws ParserException {
        if (this.changeTable != null) {
            this.changer = this.changeTable.getChanger(tag);
            this.splitter = this.changeTable.getSplitter(tag);
        } else {
            this.changer = null;
            this.splitter = null;
        }
        if (this.changer == null) {
            this.changer = this.defaultC;
        }
        if (this.splitter == null) {
            this.splitter = this.defaultS;
        }
        super.startTag(tag);
    }

    @Override
    public void value(TagValueContext ctxt, Object value) throws ParserException {
        if (this.changer != null) {
            value = this.changer.change(value);
            super.value(ctxt, value);
        } else if (this.splitter != null) {
            List values = this.splitter.split(value);
            for (Object v : values) {
                super.value(ctxt, v);
            }
        } else {
            super.value(ctxt, value);
        }
    }
}

